/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.spi.impl;

import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import org.apache.myfaces.config.annotation.DefaultAnnotationProvider;
import org.apache.myfaces.shared.util.ClassUtils;
import org.apache.myfaces.spi.AnnotationProvider;
import org.apache.myfaces.spi.AnnotationProviderFactory;
import org.apache.myfaces.spi.ServiceProviderFinderFactory;

public class DefaultAnnotationProviderFactory
extends AnnotationProviderFactory {
    public static final String ANNOTATION_PROVIDER = AnnotationProvider.class.getName();
    public static final String ANNOTATION_PROVIDER_LIST = AnnotationProvider.class.getName() + ".LIST";
    public static final String ANNOTATION_PROVIDER_INSTANCE = AnnotationProvider.class.getName() + ".INSTANCE";

    private Logger getLogger() {
        return Logger.getLogger(DefaultAnnotationProviderFactory.class.getName());
    }

    @Override
    public AnnotationProvider getAnnotationProvider(ExternalContext externalContext) {
        AnnotationProvider annotationProvider = (AnnotationProvider)externalContext.getApplicationMap().get(ANNOTATION_PROVIDER_INSTANCE);
        if (annotationProvider == null) {
            annotationProvider = this.createAnnotationProvider(externalContext);
            externalContext.getApplicationMap().put(ANNOTATION_PROVIDER_INSTANCE, annotationProvider);
        }
        return annotationProvider;
    }

    @Override
    public AnnotationProvider createAnnotationProvider(ExternalContext externalContext) {
        AnnotationProvider returnValue = null;
        final ExternalContext extContext = externalContext;
        try {
            returnValue = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedExceptionAction<AnnotationProvider>(){

                @Override
                public AnnotationProvider run() throws ClassNotFoundException, NoClassDefFoundError, InstantiationException, IllegalAccessException, InvocationTargetException, PrivilegedActionException {
                    return DefaultAnnotationProviderFactory.this.resolveAnnotationProviderFromService(extContext);
                }
            }) : this.resolveAnnotationProviderFromService(extContext);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (InstantiationException e) {
            this.getLogger().log(Level.SEVERE, "", e);
        }
        catch (IllegalAccessException e) {
            this.getLogger().log(Level.SEVERE, "", e);
        }
        catch (InvocationTargetException e) {
            this.getLogger().log(Level.SEVERE, "", e);
        }
        catch (PrivilegedActionException e) {
            throw new FacesException((Throwable)e);
        }
        return returnValue;
    }

    private AnnotationProvider resolveAnnotationProviderFromService(ExternalContext externalContext) throws ClassNotFoundException, NoClassDefFoundError, InstantiationException, IllegalAccessException, InvocationTargetException, PrivilegedActionException {
        List<String> classList = (List<String>)externalContext.getApplicationMap().get(ANNOTATION_PROVIDER_LIST);
        if (classList == null) {
            classList = ServiceProviderFinderFactory.getServiceProviderFinder(externalContext).getServiceProviderList(ANNOTATION_PROVIDER);
            externalContext.getApplicationMap().put(ANNOTATION_PROVIDER_LIST, classList);
        }
        return ClassUtils.buildApplicationObject(AnnotationProvider.class, classList, new DefaultAnnotationProvider());
    }
}

