/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.config;

import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessManagedBean;
import javax.faces.annotation.FacesConfig;
import org.apache.myfaces.cdi.config.FacesConfigBeanHolder;
import org.apache.myfaces.cdi.util.CDIUtils;

public class FacesConfigExtension
implements Extension {
    private FacesConfig.Version facesConfigVersion;

    void beforeBeanDiscovery(@Observes BeforeBeanDiscovery event, BeanManager beanManager) {
        AnnotatedType beanHolder = beanManager.createAnnotatedType(FacesConfigBeanHolder.class);
        event.addAnnotatedType(beanHolder, beanHolder.getJavaClass().getName());
    }

    public <T> void collect(@Observes ProcessManagedBean<T> event) {
        if (event.getAnnotatedBeanClass().isAnnotationPresent(FacesConfig.class)) {
            AnnotatedType annotated = event.getAnnotatedBeanClass();
            FacesConfig config = (FacesConfig)annotated.getAnnotation(FacesConfig.class);
            this.facesConfigVersion = this.facesConfigVersion != null ? (this.facesConfigVersion.ordinal() < config.version().ordinal() ? config.version() : this.facesConfigVersion) : config.version();
        }
    }

    public void afterDeploymentValidation(@Observes AfterDeploymentValidation adv, BeanManager beanManager) {
        FacesConfigBeanHolder holder = CDIUtils.lookup(beanManager, FacesConfigBeanHolder.class);
        holder.setFacesConfigVersion(this.facesConfigVersion);
    }
}

