/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.myfaces.config.FacesConfigUnmarshaller;
import org.apache.myfaces.config.element.Application;
import org.apache.myfaces.config.element.FacesFlowDefinition;
import org.apache.myfaces.config.element.LocaleConfig;
import org.apache.myfaces.config.impl.FacesConfigEntityResolver;
import org.apache.myfaces.config.impl.element.AbsoluteOrderingImpl;
import org.apache.myfaces.config.impl.element.ApplicationImpl;
import org.apache.myfaces.config.impl.element.AttributeImpl;
import org.apache.myfaces.config.impl.element.BehaviorImpl;
import org.apache.myfaces.config.impl.element.ClientBehaviorRendererImpl;
import org.apache.myfaces.config.impl.element.ConfigOthersSlotImpl;
import org.apache.myfaces.config.impl.element.ContractMappingImpl;
import org.apache.myfaces.config.impl.element.ConverterImpl;
import org.apache.myfaces.config.impl.element.FaceletsProcessingImpl;
import org.apache.myfaces.config.impl.element.FaceletsTemplateMappingImpl;
import org.apache.myfaces.config.impl.element.FacesConfigExtensionImpl;
import org.apache.myfaces.config.impl.element.FacesConfigImpl;
import org.apache.myfaces.config.impl.element.FacesConfigNameSlotImpl;
import org.apache.myfaces.config.impl.element.FacesFlowCallImpl;
import org.apache.myfaces.config.impl.element.FacesFlowDefinitionImpl;
import org.apache.myfaces.config.impl.element.FacesFlowMethodCallImpl;
import org.apache.myfaces.config.impl.element.FacesFlowMethodParameterImpl;
import org.apache.myfaces.config.impl.element.FacesFlowParameterImpl;
import org.apache.myfaces.config.impl.element.FacesFlowReferenceImpl;
import org.apache.myfaces.config.impl.element.FacesFlowReturnImpl;
import org.apache.myfaces.config.impl.element.FacesFlowSwitchImpl;
import org.apache.myfaces.config.impl.element.FacesFlowViewImpl;
import org.apache.myfaces.config.impl.element.FactoryImpl;
import org.apache.myfaces.config.impl.element.LocaleConfigImpl;
import org.apache.myfaces.config.impl.element.NavigationCaseImpl;
import org.apache.myfaces.config.impl.element.NavigationRuleImpl;
import org.apache.myfaces.config.impl.element.OrderingImpl;
import org.apache.myfaces.config.impl.element.PropertyImpl;
import org.apache.myfaces.config.impl.element.RedirectImpl;
import org.apache.myfaces.config.impl.element.RenderKitImpl;
import org.apache.myfaces.config.impl.element.RendererImpl;
import org.apache.myfaces.config.impl.element.ResourceBundleImpl;
import org.apache.myfaces.config.impl.element.SystemEventListenerImpl;
import org.apache.myfaces.config.impl.element.ViewParamImpl;
import org.apache.myfaces.config.impl.element.ViewPoolMappingImpl;
import org.apache.myfaces.config.impl.element.ViewPoolParameterImpl;
import org.apache.myfaces.util.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class FacesConfigUnmarshallerImpl
implements FacesConfigUnmarshaller<FacesConfigImpl> {
    private ExternalContext externalContext;

    public FacesConfigUnmarshallerImpl(ExternalContext externalContext) {
        this.externalContext = externalContext;
    }

    @Override
    public FacesConfigImpl getFacesConfig(String s) throws IOException, SAXException {
        return this.getFacesConfig(new ByteArrayInputStream(s.getBytes()), null);
    }

    @Override
    public FacesConfigImpl getFacesConfig(InputStream in, String systemId) throws IOException, SAXException {
        FacesConfigImpl facesConfig = new FacesConfigImpl();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new FacesConfigEntityResolver(this.externalContext));
            Document document = systemId == null ? builder.parse(in) : builder.parse(in, systemId);
            document.getDocumentElement().normalize();
            this.onAttribute("metadata-complete", document.getDocumentElement(), v -> facesConfig.setMetadataComplete((String)v));
            this.onAttribute("version", document.getDocumentElement(), v -> facesConfig.setVersion((String)v));
            this.onChild("name", document.getDocumentElement(), n -> facesConfig.setName(this.getTextContent((Node)n)));
            this.onChild("ordering", document.getDocumentElement(), n -> facesConfig.setOrdering(this.processOrdering((Node)n)));
            this.onChild("absolute-ordering", document.getDocumentElement(), n -> facesConfig.setAbsoluteOrdering(this.processAbsoluteOrdering((Node)n)));
            this.onChild("application", document.getDocumentElement(), n -> facesConfig.addApplication(this.processApplication((Node)n)));
            this.onChild("factory", document.getDocumentElement(), n -> facesConfig.addFactory(this.processFactory((Node)n)));
            this.onChild("component", document.getDocumentElement(), n -> facesConfig.addComponent(this.firstChildTextContent("component-type", (Node)n), this.firstChildTextContent("component-class", (Node)n)));
            this.onChild("lifecycle", document.getDocumentElement(), n -> this.onChild("phase-listener", (Node)n, cn -> facesConfig.addLifecyclePhaseListener(this.getTextContent((Node)cn))));
            this.onChild("validator", document.getDocumentElement(), n -> facesConfig.addValidator(this.firstChildTextContent("validator-id", (Node)n), this.firstChildTextContent("validator-class", (Node)n)));
            this.onChild("render-kit", document.getDocumentElement(), n -> facesConfig.addRenderKit(this.processRenderKit((Node)n)));
            this.onChild("behavior", document.getDocumentElement(), n -> facesConfig.addBehavior(this.processBehavior((Node)n)));
            this.onChild("converter", document.getDocumentElement(), n -> facesConfig.addConverter(this.processConverter((Node)n)));
            this.onChild("protected-views", document.getDocumentElement(), n -> this.onChild("url-pattern", (Node)n, cn -> facesConfig.addProtectedViewUrlPattern(this.getTextContent((Node)cn))));
            this.onChild("faces-config-extension", document.getDocumentElement(), n -> facesConfig.addFacesConfigExtension(this.processFacesConfigExtension((Node)n)));
            this.onChild("navigation-rule", document.getDocumentElement(), n -> facesConfig.addNavigationRule(this.processNavigationRule((Node)n)));
            this.onChild("flow-definition", document.getDocumentElement(), n -> facesConfig.addFacesFlowDefinition(this.processFlowDefinition((Node)n)));
        }
        catch (Exception e) {
            throw new FacesException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        this.postProcessFacesConfig(systemId, facesConfig);
        return facesConfig;
    }

    private void postProcessFacesConfig(String systemId, FacesConfigImpl config) {
        for (Application application : config.getApplications()) {
            for (LocaleConfig localeConfig : application.getLocaleConfig()) {
                if (localeConfig.getSupportedLocales().contains(localeConfig.getDefaultLocale())) continue;
                localeConfig.addSupportedLocale(localeConfig.getDefaultLocale());
            }
        }
        for (FacesFlowDefinition facesFlowDefinition : config.getFacesFlowDefinitions()) {
            if (config.getName() != null) {
                ((FacesFlowDefinitionImpl)facesFlowDefinition).setDefiningDocumentId(config.getName());
                continue;
            }
            ((FacesFlowDefinitionImpl)facesFlowDefinition).setDefiningDocumentId("");
        }
    }

    protected OrderingImpl processOrdering(Node node) {
        OrderingImpl obj = new OrderingImpl();
        this.onChild("before", node, n -> {
            this.onChild("name", (Node)n, cn -> obj.addBeforeSlot(new FacesConfigNameSlotImpl(this.getTextContent((Node)cn))));
            this.onChild("others", (Node)n, cn -> obj.addBeforeSlot(new ConfigOthersSlotImpl()));
        });
        this.onChild("after", node, n -> {
            this.onChild("name", (Node)n, cn -> obj.addAfterSlot(new FacesConfigNameSlotImpl(this.getTextContent((Node)cn))));
            this.onChild("others", (Node)n, cn -> obj.addAfterSlot(new ConfigOthersSlotImpl()));
        });
        return obj;
    }

    protected AbsoluteOrderingImpl processAbsoluteOrdering(Node node) {
        AbsoluteOrderingImpl obj = new AbsoluteOrderingImpl();
        this.forEachChild(node, n -> {
            if ("name".equals(n.getLocalName())) {
                FacesConfigNameSlotImpl slot = new FacesConfigNameSlotImpl();
                slot.setName(this.getTextContent((Node)n));
                obj.addOrderSlot(slot);
            } else if ("others".equals(n.getLocalName())) {
                obj.addOrderSlot(new ConfigOthersSlotImpl());
            }
        });
        return obj;
    }

    protected ApplicationImpl processApplication(Node node) {
        ApplicationImpl obj = new ApplicationImpl();
        this.onChild("action-listener", node, n -> obj.addActionListener(this.getTextContent((Node)n)));
        this.onChild("message-bundle", node, n -> obj.addMessageBundle(this.getTextContent((Node)n)));
        this.onChild("navigation-handler", node, n -> obj.addNavigationHandler(this.getTextContent((Node)n)));
        this.onChild("view-handler", node, n -> obj.addViewHandler(this.getTextContent((Node)n)));
        this.onChild("state-manager", node, n -> obj.addStateManager(this.getTextContent((Node)n)));
        this.onChild("property-resolver", node, n -> obj.addPropertyResolver(this.getTextContent((Node)n)));
        this.onChild("variable-resolver", node, n -> obj.addVariableResolver(this.getTextContent((Node)n)));
        this.onChild("el-resolver", node, n -> obj.addElResolver(this.getTextContent((Node)n)));
        this.onChild("resource-handler", node, n -> obj.addResourceHandler(this.getTextContent((Node)n)));
        this.onChild("default-render-kit-id", node, n -> obj.addDefaultRenderkitId(this.getTextContent((Node)n)));
        this.onChild("search-expression-handler", node, n -> obj.addSearchExpressionHandler(this.getTextContent((Node)n)));
        this.onChild("search-keyword-resolver", node, n -> obj.addSearchKeywordResolver(this.getTextContent((Node)n)));
        this.onChild("default-validators", node, n -> {
            obj.setDefaultValidatorsPresent();
            this.onChild("validator-id", (Node)n, cn -> obj.addDefaultValidatorId(this.getTextContent((Node)cn)));
        });
        this.onChild("locale-config", node, n -> {
            LocaleConfigImpl lc = new LocaleConfigImpl();
            this.onChild("default-locale", (Node)n, cn -> lc.setDefaultLocale(this.getTextContent((Node)cn)));
            this.onChild("supported-locale", (Node)n, cn -> lc.addSupportedLocale(this.getTextContent((Node)cn)));
            obj.addLocaleConfig(lc);
        });
        this.onChild("resource-bundle", node, n -> {
            ResourceBundleImpl rb = new ResourceBundleImpl();
            this.onChild("base-name", (Node)n, cn -> rb.setBaseName(this.getTextContent((Node)cn)));
            this.onChild("var", (Node)n, cn -> rb.setVar(this.getTextContent((Node)cn)));
            this.onChild("display-name", (Node)n, cn -> rb.setDisplayName(this.getTextContent((Node)cn)));
            obj.addResourceBundle(rb);
        });
        this.onChild("system-event-listener", node, n -> {
            SystemEventListenerImpl sel = new SystemEventListenerImpl();
            this.onChild("system-event-listener-class", (Node)n, cn -> sel.setSystemEventListenerClass(this.getTextContent((Node)cn)));
            this.onChild("system-event-class", (Node)n, cn -> sel.setSystemEventClass(this.getTextContent((Node)cn)));
            this.onChild("source-class", (Node)n, cn -> sel.setSourceClass(this.getTextContent((Node)cn)));
            obj.addSystemEventListener(sel);
        });
        this.onChild("resource-library-contracts", node, n -> this.onChild("contract-mapping", (Node)n, cn -> {
            ContractMappingImpl cm = new ContractMappingImpl();
            this.onChild("url-pattern", (Node)cn, ccn -> cm.addUrlPattern(this.getTextContent((Node)ccn)));
            this.onChild("contracts", (Node)cn, ccn -> cm.addContract(this.getTextContent((Node)ccn)));
            obj.addResourceLibraryContractMapping(cm);
        }));
        return obj;
    }

    protected FactoryImpl processFactory(Node node) {
        FactoryImpl obj = new FactoryImpl();
        this.onChild("application-factory", node, n -> obj.addApplicationFactory(this.getTextContent((Node)n)));
        this.onChild("faces-context-factory", node, n -> obj.addFacesContextFactory(this.getTextContent((Node)n)));
        this.onChild("lifecycle-factory", node, n -> obj.addLifecycleFactory(this.getTextContent((Node)n)));
        this.onChild("render-kit-factory", node, n -> obj.addRenderkitFactory(this.getTextContent((Node)n)));
        this.onChild("exception-handler-factory", node, n -> obj.addExceptionHandlerFactory(this.getTextContent((Node)n)));
        this.onChild("external-context-factory", node, n -> obj.addExternalContextFactory(this.getTextContent((Node)n)));
        this.onChild("view-declaration-language-factory", node, n -> obj.addViewDeclarationLanguageFactory(this.getTextContent((Node)n)));
        this.onChild("partial-view-context-factory", node, n -> obj.addPartialViewContextFactory(this.getTextContent((Node)n)));
        this.onChild("tag-handler-delegate-factory", node, n -> obj.addTagHandlerDelegateFactory(this.getTextContent((Node)n)));
        this.onChild("visit-context-factory", node, n -> obj.addVisitContextFactory(this.getTextContent((Node)n)));
        this.onChild("search-expression-context-factory", node, n -> obj.addSearchExpressionContextFactory(this.getTextContent((Node)n)));
        this.onChild("facelet-cache-factory", node, n -> obj.addFaceletCacheFactory(this.getTextContent((Node)n)));
        this.onChild("flash-factory", node, n -> obj.addFlashFactory(this.getTextContent((Node)n)));
        this.onChild("flow-handler-factory", node, n -> obj.addFlowHandlerFactory(this.getTextContent((Node)n)));
        this.onChild("client-window-factory", node, n -> obj.addClientWindowFactory(this.getTextContent((Node)n)));
        return obj;
    }

    protected RenderKitImpl processRenderKit(Node node) {
        RenderKitImpl obj = new RenderKitImpl();
        this.onChild("render-kit-id", node, n -> obj.setId(this.getTextContent((Node)n)));
        this.onChild("render-kit-class", node, n -> obj.addRenderKitClass(this.getTextContent((Node)n)));
        this.onChild("renderer", node, n -> {
            RendererImpl r = new RendererImpl();
            this.onChild("component-family", (Node)n, cn -> r.setComponentFamily(this.getTextContent((Node)cn)));
            this.onChild("renderer-type", (Node)n, cn -> r.setRendererType(this.getTextContent((Node)cn)));
            this.onChild("renderer-class", (Node)n, cn -> r.setRendererClass(this.getTextContent((Node)cn)));
            obj.addRenderer(r);
        });
        this.onChild("client-behavior-renderer", node, n -> {
            ClientBehaviorRendererImpl r = new ClientBehaviorRendererImpl();
            this.onChild("client-behavior-renderer-type", (Node)n, cn -> r.setRendererType(this.getTextContent((Node)cn)));
            this.onChild("client-behavior-renderer-class", (Node)n, cn -> r.setRendererClass(this.getTextContent((Node)cn)));
            obj.addClientBehaviorRenderer(r);
        });
        return obj;
    }

    protected BehaviorImpl processBehavior(Node node) {
        BehaviorImpl obj = new BehaviorImpl();
        this.onChild("behavior-id", node, n -> obj.setBehaviorId(this.getTextContent((Node)n)));
        this.onChild("behavior-class", node, n -> obj.setBehaviorClass(this.getTextContent((Node)n)));
        this.onChild("attribute", node, n -> {
            AttributeImpl a = new AttributeImpl();
            this.onChild("description", (Node)n, cn -> a.addDescription(this.getTextContent((Node)cn)));
            this.onChild("display-name", (Node)n, cn -> a.addDisplayName(this.getTextContent((Node)cn)));
            this.onChild("icon", (Node)n, cn -> a.addIcon(this.getTextContent((Node)cn)));
            this.onChild("attribute-name", (Node)n, cn -> a.setAttributeName(this.getTextContent((Node)cn)));
            this.onChild("attribute-class", (Node)n, cn -> a.setAttributeClass(this.getTextContent((Node)cn)));
            this.onChild("default-value", (Node)n, cn -> a.setDefaultValue(this.getTextContent((Node)cn)));
            this.onChild("suggested-value", (Node)n, cn -> a.setSuggestedValue(this.getTextContent((Node)cn)));
            this.onChild("attribute-extension", (Node)n, cn -> a.addAttributeExtension(this.getTextContent((Node)cn)));
            obj.addAttribute(a);
        });
        this.onChild("property", node, n -> {
            PropertyImpl p = new PropertyImpl();
            this.onChild("description", (Node)n, cn -> p.addDescription(this.getTextContent((Node)cn)));
            this.onChild("display-name", (Node)n, cn -> p.addDisplayName(this.getTextContent((Node)cn)));
            this.onChild("icon", (Node)n, cn -> p.addIcon(this.getTextContent((Node)cn)));
            this.onChild("property-name", (Node)n, cn -> p.setPropertyName(this.getTextContent((Node)cn)));
            this.onChild("property-class", (Node)n, cn -> p.setPropertyClass(this.getTextContent((Node)cn)));
            this.onChild("default-value", (Node)n, cn -> p.setDefaultValue(this.getTextContent((Node)cn)));
            this.onChild("suggested-value", (Node)n, cn -> p.setSuggestedValue(this.getTextContent((Node)cn)));
            this.onChild("property-extension", (Node)n, cn -> p.addPropertyExtension(this.getTextContent((Node)cn)));
            obj.addProperty(p);
        });
        return obj;
    }

    protected ConverterImpl processConverter(Node node) {
        ConverterImpl obj = new ConverterImpl();
        this.onChild("converter-id", node, n -> obj.setConverterId(this.getTextContent((Node)n)));
        this.onChild("converter-for-class", node, n -> obj.setForClass(this.getTextContent((Node)n)));
        this.onChild("converter-class", node, n -> obj.setConverterClass(this.getTextContent((Node)n)));
        this.onChild("attribute", node, n -> {
            AttributeImpl a = new AttributeImpl();
            this.onChild("description", (Node)n, cn -> a.addDescription(this.getTextContent((Node)cn)));
            this.onChild("display-name", (Node)n, cn -> a.addDisplayName(this.getTextContent((Node)cn)));
            this.onChild("icon", (Node)n, cn -> a.addIcon(this.getTextContent((Node)cn)));
            this.onChild("attribute-name", (Node)n, cn -> a.setAttributeName(this.getTextContent((Node)cn)));
            this.onChild("attribute-class", (Node)n, cn -> a.setAttributeClass(this.getTextContent((Node)cn)));
            this.onChild("default-value", (Node)n, cn -> a.setDefaultValue(this.getTextContent((Node)cn)));
            this.onChild("suggested-value", (Node)n, cn -> a.setSuggestedValue(this.getTextContent((Node)cn)));
            this.onChild("attribute-extension", (Node)n, cn -> a.addAttributeExtension(this.getTextContent((Node)cn)));
            obj.addAttribute(a);
        });
        this.onChild("property", node, n -> {
            PropertyImpl p = new PropertyImpl();
            this.onChild("description", (Node)n, cn -> p.addDescription(this.getTextContent((Node)cn)));
            this.onChild("display-name", (Node)n, cn -> p.addDisplayName(this.getTextContent((Node)cn)));
            this.onChild("icon", (Node)n, cn -> p.addIcon(this.getTextContent((Node)cn)));
            this.onChild("property-name", (Node)n, cn -> p.setPropertyName(this.getTextContent((Node)cn)));
            this.onChild("property-class", (Node)n, cn -> p.setPropertyClass(this.getTextContent((Node)cn)));
            this.onChild("default-value", (Node)n, cn -> p.setDefaultValue(this.getTextContent((Node)cn)));
            this.onChild("suggested-value", (Node)n, cn -> p.setSuggestedValue(this.getTextContent((Node)cn)));
            this.onChild("property-extension", (Node)n, cn -> p.addPropertyExtension(this.getTextContent((Node)cn)));
            obj.addProperty(p);
        });
        return obj;
    }

    protected FacesConfigExtensionImpl processFacesConfigExtension(Node node) {
        FacesConfigExtensionImpl obj = new FacesConfigExtensionImpl();
        this.onChild("facelets-processing", node, n -> {
            FaceletsProcessingImpl fp = new FaceletsProcessingImpl();
            this.onChild("file-extension", (Node)n, cn -> fp.setFileExtension(this.getTextContent((Node)cn)));
            this.onChild("process-as", (Node)n, cn -> fp.setProcessAs(this.getTextContent((Node)cn)));
            this.onChild("oam-compress-spaces", (Node)n, cn -> fp.setOamCompressSpaces(this.getTextContent((Node)cn)));
            obj.addFaceletsProcessing(fp);
        });
        this.onChild("view-pool-mapping", node, n -> {
            ViewPoolMappingImpl vpm = new ViewPoolMappingImpl();
            this.onChild("url-pattern", (Node)n, cn -> vpm.setUrlPattern(this.getTextContent((Node)cn)));
            this.onChild("parameter", (Node)n, cn -> {
                ViewPoolParameterImpl vpp = new ViewPoolParameterImpl();
                this.onChild("name", (Node)cn, ccn -> vpp.setName(this.getTextContent((Node)ccn)));
                this.onChild("value", (Node)cn, ccn -> vpp.setValue(this.getTextContent((Node)ccn)));
                vpm.addParameter(vpp);
            });
            obj.addViewPoolMapping(vpm);
        });
        this.onChild("facelets-template-mapping", node, n -> {
            FaceletsTemplateMappingImpl ftm = new FaceletsTemplateMappingImpl();
            this.onChild("url-pattern", (Node)n, cn -> ftm.setUrlPattern(this.getTextContent((Node)cn)));
            obj.addFaceletsTemplateMapping(ftm);
        });
        return obj;
    }

    protected NavigationRuleImpl processNavigationRule(Node node) {
        NavigationRuleImpl obj = new NavigationRuleImpl();
        this.onChild("from-view-id", node, n -> obj.setFromViewId(this.getTextContent((Node)n)));
        this.onChild("navigation-case", node, n -> obj.addNavigationCase(this.processNavigationCase((Node)n)));
        return obj;
    }

    protected FacesFlowDefinitionImpl processFlowDefinition(Node node) {
        FacesFlowDefinitionImpl obj = new FacesFlowDefinitionImpl();
        this.onAttribute("id", node, v -> obj.setId((String)v));
        this.onChild("start-node", node, n -> obj.setStartNode(this.getTextContent((Node)n)));
        this.onChild("initializer", node, n -> obj.setInitializer(this.getTextContent((Node)n)));
        this.onChild("finalizer", node, n -> obj.setFinalizer(this.getTextContent((Node)n)));
        this.onChild("view", node, n -> {
            FacesFlowViewImpl ffv = new FacesFlowViewImpl();
            this.onAttribute("id", (Node)n, v -> ffv.setId((String)v));
            this.onChild("vdl-document", (Node)n, cn -> ffv.setVdlDocument(this.getTextContent((Node)cn)));
            obj.addView(ffv);
        });
        this.onChild("switch", node, n -> {
            FacesFlowSwitchImpl ffs = new FacesFlowSwitchImpl();
            this.onAttribute("id", (Node)n, v -> ffs.setId((String)v));
            this.onChild("case", (Node)n, cn -> ffs.addNavigationCase(this.processNavigationCase((Node)cn)));
            this.onChild("default-outcome", (Node)n, cn -> {
                NavigationCaseImpl nc = new NavigationCaseImpl();
                nc.setFromAction(this.getTextContent((Node)cn));
                ffs.setDefaultOutcome(nc);
            });
            obj.addSwitch(ffs);
        });
        this.onChild("flow-return", node, n -> {
            FacesFlowReturnImpl ffr = new FacesFlowReturnImpl();
            this.onAttribute("id", (Node)n, v -> ffr.setId((String)v));
            this.onChild("from-outcome", (Node)n, cn -> {
                NavigationCaseImpl nc = new NavigationCaseImpl();
                nc.setFromOutcome(this.getTextContent((Node)cn));
                ffr.setNavigationCase(nc);
            });
            obj.addReturn(ffr);
        });
        this.onChild("navigation-rule", node, n -> {
            NavigationRuleImpl nr = new NavigationRuleImpl();
            this.onChild("from-view-id", (Node)n, cn -> nr.setFromViewId(this.getTextContent((Node)cn)));
            this.onChild("navigation-case", (Node)n, cn -> nr.addNavigationCase(this.processNavigationCase((Node)cn)));
            obj.addNavigationRule(nr);
        });
        this.onChild("flow-call", node, n -> {
            FacesFlowCallImpl ffc = new FacesFlowCallImpl();
            this.onAttribute("id", (Node)n, v -> ffc.setId((String)v));
            this.onChild("flow-reference", (Node)n, cn -> {
                FacesFlowReferenceImpl ffr = new FacesFlowReferenceImpl();
                this.onChild("flow-document-id", (Node)cn, ccn -> ffr.setFlowDocumentId(this.getTextContent((Node)ccn)));
                this.onChild("flow-id", (Node)cn, ccn -> ffr.setFlowId(this.getTextContent((Node)ccn)));
                ffc.setFlowReference(ffr);
            });
            this.onChild("outbound-parameter", (Node)n, cn -> {
                FacesFlowParameterImpl ffp = new FacesFlowParameterImpl();
                this.onChild("name", (Node)cn, ccn -> ffp.setName(this.getTextContent((Node)ccn)));
                this.onChild("value", (Node)cn, ccn -> ffp.setValue(this.getTextContent((Node)ccn)));
                ffc.addOutboundParameter(ffp);
            });
            obj.addFlowCall(ffc);
        });
        this.onChild("method-call", node, n -> {
            FacesFlowMethodCallImpl ffmc = new FacesFlowMethodCallImpl();
            this.onAttribute("id", (Node)n, v -> ffmc.setId((String)v));
            this.onChild("method", (Node)n, cn -> ffmc.setMethod(this.getTextContent((Node)cn)));
            this.onChild("default-outcome", (Node)n, cn -> ffmc.setDefaultOutcome(this.getTextContent((Node)cn)));
            this.onChild("parameter", (Node)n, cn -> {
                FacesFlowMethodParameterImpl ffmp = new FacesFlowMethodParameterImpl();
                this.onChild("class", (Node)cn, ccn -> ffmp.setClassName(this.getTextContent((Node)ccn)));
                this.onChild("value", (Node)cn, ccn -> ffmp.setValue(this.getTextContent((Node)ccn)));
                ffmc.addParameter(ffmp);
            });
            obj.addMethodCall(ffmc);
        });
        this.onChild("inbound-parameter", node, n -> {
            FacesFlowParameterImpl ffp = new FacesFlowParameterImpl();
            this.onChild("name", (Node)n, cn -> ffp.setName(this.getTextContent((Node)cn)));
            this.onChild("value", (Node)n, cn -> ffp.setValue(this.getTextContent((Node)cn)));
            obj.addInboundParameter(ffp);
        });
        return obj;
    }

    private NavigationCaseImpl processNavigationCase(Node node) {
        NavigationCaseImpl obj = new NavigationCaseImpl();
        this.onChild("from-action", node, n -> obj.setFromAction(this.getTextContent((Node)n)));
        this.onChild("from-outcome", node, n -> obj.setFromOutcome(this.getTextContent((Node)n)));
        this.onChild("if", node, n -> obj.setIf(this.getTextContent((Node)n)));
        this.onChild("to-view-id", node, n -> obj.setToViewId(this.getTextContent((Node)n)));
        this.onChild("redirect", node, n -> {
            RedirectImpl r = new RedirectImpl();
            this.onChild("include-view-params", (Node)n, cn -> r.setIncludeViewParams("true"));
            this.onChild("view-param", (Node)n, cn -> {
                ViewParamImpl vp = new ViewParamImpl();
                this.onChild("name", (Node)cn, ccn -> vp.setName(this.getTextContent((Node)ccn)));
                this.onChild("value", (Node)cn, ccn -> vp.setValue(this.getTextContent((Node)ccn)));
                r.addViewParam(vp);
            });
            this.onChild("redirect-param", (Node)n, cn -> {
                ViewParamImpl vp = new ViewParamImpl();
                this.onChild("name", (Node)cn, ccn -> vp.setName(this.getTextContent((Node)ccn)));
                this.onChild("value", (Node)cn, ccn -> vp.setValue(this.getTextContent((Node)ccn)));
                r.addViewParam(vp);
            });
            obj.setRedirect(r);
        });
        return obj;
    }

    protected void onAttribute(String name, Node node, Consumer<String> val) {
        Element element;
        if (node instanceof Element && (element = (Element)node).hasAttribute(name)) {
            val.accept(element.getAttribute(name));
        }
    }

    protected void forEachChild(Node node, Consumer<Node> val) {
        if (node.getChildNodes() != null) {
            for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
                Node childNode = node.getChildNodes().item(i);
                if (childNode == null) continue;
                val.accept(childNode);
            }
        }
    }

    protected void onChild(String name, Node node, Consumer<Node> val) {
        if (node.getChildNodes() != null) {
            for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
                Node childNode = node.getChildNodes().item(i);
                if (childNode == null || !name.equals(childNode.getLocalName())) continue;
                val.accept(childNode);
            }
        }
    }

    protected String firstChildTextContent(String name, Node node) {
        if (node.getChildNodes() != null) {
            for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
                Node childNode = node.getChildNodes().item(i);
                if (childNode == null || !name.equals(childNode.getLocalName())) continue;
                return childNode.getTextContent();
            }
        }
        return null;
    }

    protected String getTextContent(Node node) {
        if (node == null) {
            return null;
        }
        String textContent = node.getTextContent();
        if (textContent != null) {
            textContent = textContent.trim();
        }
        return StringUtils.isBlank(textContent) ? null : textContent;
    }
}

