/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi;

import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterTypeDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.faces.annotation.FacesConfig;
import org.apache.myfaces.cdi.JsfArtifactFlowMapProducer;
import org.apache.myfaces.cdi.JsfArtifactProducer;

public class JsfArtifactProducerExtension
implements Extension {
    private boolean registerCdiProducers = false;

    <T> void processAnnotatedType(@Observes ProcessAnnotatedType<T> event, BeanManager beanManager) {
        FacesConfig facesConfig = (FacesConfig)event.getAnnotatedType().getAnnotation(FacesConfig.class);
        if (facesConfig != null && facesConfig.version() == FacesConfig.Version.JSF_2_3) {
            this.registerCdiProducers = true;
        }
    }

    void afterTypeDiscovery(@Observes AfterTypeDiscovery event, BeanManager beanManager) {
        if (this.registerCdiProducers) {
            AnnotatedType jsfArtifactProducer = beanManager.createAnnotatedType(JsfArtifactProducer.class);
            event.addAnnotatedType(jsfArtifactProducer, jsfArtifactProducer.getJavaClass().getName());
        }
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        if (this.registerCdiProducers) {
            afterBeanDiscovery.addBean((Bean)new JsfArtifactFlowMapProducer(beanManager));
        }
    }

    public boolean isRegisterCdiProducers() {
        return this.registerCdiProducers;
    }
}

