/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.util;

import java.util.logging.Logger;
import javax.faces.context.FacesContext;
import org.apache.myfaces.renderkit.html.util.JavascriptContext;
import org.apache.myfaces.renderkit.html.util.JavascriptUtils;

public final class HtmlJavaScriptUtils {
    private static final Logger log = Logger.getLogger(HtmlJavaScriptUtils.class.getName());

    public static void appendClearHiddenCommandFormParamsFunctionCall(StringBuilder buf, String formName) {
        HtmlJavaScriptUtils.appendClearHiddenCommandFormParamsFunctionCall(new JavascriptContext(buf, false), formName);
    }

    private static void appendClearHiddenCommandFormParamsFunctionCall(JavascriptContext context, String formName) {
        String functionName = HtmlJavaScriptUtils.getClearHiddenCommandFormParamsFunctionName(formName);
        if (formName == null) {
            context.prettyLine();
            context.append("var clearFn = ");
            context.append(functionName);
            context.append(";");
            context.prettyLine();
            context.append("if(typeof window[clearFn] =='function')");
            context.append("{");
            context.append("window[clearFn](formName);");
            context.append("}");
        } else {
            context.prettyLine();
            context.append("if(typeof window.");
            context.append(functionName);
            context.append("=='function')");
            context.append("{");
            context.append(functionName).append("('").append(formName).append("');");
            context.append("}");
        }
    }

    public static String getClearHiddenCommandFormParamsFunctionName(String formName) {
        char separatorChar = FacesContext.getCurrentInstance().getNamingContainerSeparatorChar();
        if (formName == null) {
            return "'clearFormHiddenParams_'+formName.replace(/-/g, '\\$" + separatorChar + "').replace(/" + separatorChar + "/g,'_')";
        }
        return JavascriptUtils.getValidJavascriptNameAsInRI("clearFormHiddenParams_" + formName.replace(separatorChar, '_'));
    }

    public static String getClearHiddenCommandFormParamsFunctionNameMyfacesLegacy(String formName) {
        return "clear_" + JavascriptUtils.getValidJavascriptName(formName, false);
    }
}

