/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.util;

import java.io.IOException;
import javax.faces.FacesWrapper;
import javax.faces.application.Resource;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialViewContext;
import javax.faces.context.ResponseWriter;
import org.apache.myfaces.resource.ContractResource;

public class ResourceUtils {
    public static final String MYFACES_LIBRARY_NAME = "org.apache.myfaces";
    public static final String JSF_MYFACES_JSFJS_MINIMAL = "minimal";
    public static final String JSF_MYFACES_JSFJS_NORMAL = "normal";
    public static final String JSF_UNCOMPRESSED_JS_RESOURCE_NAME = "jsf-uncompressed.js";
    public static final String JSF_UNCOMPRESSED_FULL_JS_RESOURCE_NAME = "jsf-uncompressed-full.js";
    public static final String JSF_MINIMAL_JS_RESOURCE_NAME = "jsf-minimal.js";
    public static final String JSF_MYFACES_JSFJS_I18N = "jsf-i18n.js";
    private static final String RENDERED_JSF_JS = "org.apache.myfaces.RENDERED_JSF_JS";
    public static final String JAVAX_FACES_OUTPUT_COMPONENT_TYPE = "javax.faces.Output";
    public static final String JAVAX_FACES_TEXT_RENDERER_TYPE = "javax.faces.Text";
    public static final String DEFAULT_SCRIPT_RENDERER_TYPE = "javax.faces.resource.Script";
    public static final String DEFAULT_STYLESHEET_RENDERER_TYPE = "javax.faces.resource.Stylesheet";

    public static void markScriptAsRendered(FacesContext facesContext, String libraryName, String resourceName) {
        facesContext.getApplication().getResourceHandler().markResourceRendered(facesContext, resourceName, libraryName);
    }

    public static void markStylesheetAsRendered(FacesContext facesContext, String libraryName, String resourceName) {
        facesContext.getApplication().getResourceHandler().markResourceRendered(facesContext, resourceName, libraryName);
    }

    public static boolean isRenderedScript(FacesContext facesContext, String libraryName, String resourceName) {
        return facesContext.getApplication().getResourceHandler().isResourceRendered(facesContext, resourceName, libraryName);
    }

    public static boolean isRenderedStylesheet(FacesContext facesContext, String libraryName, String resourceName) {
        return facesContext.getApplication().getResourceHandler().isResourceRendered(facesContext, resourceName, libraryName);
    }

    public static void writeScriptInline(FacesContext facesContext, ResponseWriter writer, String libraryName, String resourceName) throws IOException {
        if (!ResourceUtils.isRenderedScript(facesContext, libraryName, resourceName)) {
            Resource resource = facesContext.getApplication().getResourceHandler().createResource(resourceName, libraryName);
            ResourceUtils.markScriptAsRendered(facesContext, libraryName, resourceName);
            writer.startElement("script", null);
            writer.writeAttribute("type", (Object)"text/javascript", null);
            writer.writeURIAttribute("src", (Object)resource.getRequestPath(), null);
            writer.endElement("script");
        }
    }

    public static void renderDefaultJsfJsInlineIfNecessary(FacesContext facesContext, ResponseWriter writer) throws IOException {
        if (facesContext.getAttributes().containsKey(RENDERED_JSF_JS)) {
            return;
        }
        if (ResourceUtils.isRenderedScript(facesContext, "javax.faces", "jsf.js")) {
            facesContext.getAttributes().put(RENDERED_JSF_JS, Boolean.TRUE);
            return;
        }
        PartialViewContext partialViewContext = facesContext.getPartialViewContext();
        if (partialViewContext != null && (partialViewContext.isPartialRequest() || partialViewContext.isAjaxRequest())) {
            return;
        }
        Resource resource = facesContext.getApplication().getResourceHandler().createResource("jsf.js", "javax.faces");
        ResourceUtils.markScriptAsRendered(facesContext, "javax.faces", "jsf.js");
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.writeURIAttribute("src", (Object)resource.getRequestPath(), null);
        writer.endElement("script");
        facesContext.getAttributes().put(RENDERED_JSF_JS, Boolean.TRUE);
    }

    public static String getContractName(Resource resource) {
        while (resource != null) {
            if (resource instanceof ContractResource) {
                return ((ContractResource)resource).getContractName();
            }
            if (resource instanceof FacesWrapper) {
                resource = (Resource)((FacesWrapper)resource).getWrapped();
                continue;
            }
            resource = null;
        }
        return null;
    }
}

