/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag;

import java.lang.reflect.Method;
import javax.faces.FacesException;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;
import org.apache.myfaces.view.facelets.tag.TagLibrary;
import org.apache.myfaces.view.facelets.util.ParameterCheck;

public final class CompositeTagLibrary
implements TagLibrary {
    private final TagLibrary[] libraries;

    public CompositeTagLibrary(TagLibrary[] libraries) {
        ParameterCheck.notNull("libraries", libraries);
        this.libraries = libraries;
    }

    public boolean containsNamespace(String ns) {
        for (int i = 0; i < this.libraries.length; ++i) {
            if (!this.libraries[i].containsNamespace(ns)) continue;
            return true;
        }
        return false;
    }

    public boolean containsTagHandler(String ns, String localName) {
        for (int i = 0; i < this.libraries.length; ++i) {
            if (!this.libraries[i].containsTagHandler(ns, localName)) continue;
            return true;
        }
        return false;
    }

    public TagHandler createTagHandler(String ns, String localName, TagConfig tag) throws FacesException {
        for (int i = 0; i < this.libraries.length; ++i) {
            if (!this.libraries[i].containsTagHandler(ns, localName)) continue;
            return this.libraries[i].createTagHandler(ns, localName, tag);
        }
        return null;
    }

    public boolean containsFunction(String ns, String name) {
        for (int i = 0; i < this.libraries.length; ++i) {
            if (!this.libraries[i].containsFunction(ns, name)) continue;
            return true;
        }
        return false;
    }

    public Method createFunction(String ns, String name) {
        for (int i = 0; i < this.libraries.length; ++i) {
            if (!this.libraries[i].containsFunction(ns, name)) continue;
            return this.libraries[i].createFunction(ns, name);
        }
        return null;
    }
}

