/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;

class _ComponentAttributesMap
implements Map,
Serializable {
    private static final long serialVersionUID = -9106832179394257866L;
    private static final Object[] EMPTY_ARGS = new Object[0];
    private UIComponent _component;
    private Map _attributes = null;
    private transient Map _propertyDescriptorMap = null;

    _ComponentAttributesMap(UIComponent component) {
        this._component = component;
        this._attributes = new HashMap();
    }

    _ComponentAttributesMap(UIComponent component, Map attributes) {
        this._component = component;
        this._attributes = attributes;
    }

    public int size() {
        return this._attributes.size();
    }

    public void clear() {
        this._attributes.clear();
    }

    public boolean isEmpty() {
        return this._attributes.isEmpty();
    }

    public boolean containsKey(Object key) {
        this.checkKey(key);
        if (this.getPropertyDescriptor((String)key) == null) {
            return this._attributes.containsKey(key);
        }
        return false;
    }

    public boolean containsValue(Object value) {
        return this._attributes.containsValue(value);
    }

    public Collection values() {
        return this._attributes.values();
    }

    public void putAll(Map t) {
        Iterator it = t.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Set entrySet() {
        return this._attributes.entrySet();
    }

    public Set keySet() {
        return this._attributes.keySet();
    }

    public Object get(Object key) {
        this.checkKey(key);
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor((String)key);
        if (propertyDescriptor != null) {
            return this.getComponentProperty(propertyDescriptor);
        }
        Object mapValue = this._attributes.get(key);
        if (mapValue != null) {
            return mapValue;
        }
        ValueBinding vb = this._component.getValueBinding((String)key);
        if (vb != null) {
            return vb.getValue(this._component.getFacesContext());
        }
        return null;
    }

    public Object remove(Object key) {
        this.checkKey(key);
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor((String)key);
        if (propertyDescriptor != null) {
            throw new IllegalArgumentException("Cannot remove component property attribute");
        }
        return this._attributes.remove(key);
    }

    public Object put(Object key, Object value) {
        this.checkKey(key);
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor((String)key);
        if (propertyDescriptor == null && value == null) {
            throw new NullPointerException("value is null for a not available property: " + key);
        }
        if (propertyDescriptor != null) {
            if (propertyDescriptor.getReadMethod() != null) {
                Object oldValue = this.getComponentProperty(propertyDescriptor);
                this.setComponentProperty(propertyDescriptor, value);
                return oldValue;
            }
            this.setComponentProperty(propertyDescriptor, value);
            return null;
        }
        return this._attributes.put(key, value);
    }

    private PropertyDescriptor getPropertyDescriptor(String key) {
        if (this._propertyDescriptorMap == null) {
            BeanInfo beanInfo;
            try {
                beanInfo = Introspector.getBeanInfo(this._component.getClass());
            }
            catch (IntrospectionException e) {
                throw new FacesException(e);
            }
            PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
            this._propertyDescriptorMap = new HashMap();
            for (int i = 0; i < propertyDescriptors.length; ++i) {
                PropertyDescriptor propertyDescriptor = propertyDescriptors[i];
                if (propertyDescriptor.getReadMethod() == null) continue;
                this._propertyDescriptorMap.put(propertyDescriptor.getName(), propertyDescriptor);
            }
        }
        return (PropertyDescriptor)this._propertyDescriptorMap.get(key);
    }

    private Object getComponentProperty(PropertyDescriptor propertyDescriptor) {
        Method readMethod = propertyDescriptor.getReadMethod();
        if (readMethod == null) {
            throw new IllegalArgumentException("Component property " + propertyDescriptor.getName() + " is not readable");
        }
        try {
            return readMethod.invoke((Object)this._component, EMPTY_ARGS);
        }
        catch (Exception e) {
            FacesContext facesContext = this._component.getFacesContext();
            throw new FacesException("Could not get property " + propertyDescriptor.getName() + " of component " + this._component.getClientId(facesContext), e);
        }
    }

    private void setComponentProperty(PropertyDescriptor propertyDescriptor, Object value) {
        Method writeMethod = propertyDescriptor.getWriteMethod();
        if (writeMethod == null) {
            throw new IllegalArgumentException("Component property " + propertyDescriptor.getName() + " is not writable");
        }
        try {
            writeMethod.invoke((Object)this._component, value);
        }
        catch (Exception e) {
            FacesContext facesContext = this._component.getFacesContext();
            throw new FacesException("Could not set property " + propertyDescriptor.getName() + " of component " + this._component.getClientId(facesContext) + " to value : " + value + " with type : " + (value == null ? "null" : value.getClass().getName()), e);
        }
    }

    private void checkKey(Object key) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (!(key instanceof String)) {
            throw new ClassCastException("key is not a String");
        }
    }

    Map getUnderlyingMap() {
        return this._attributes;
    }

    public boolean equals(Object obj) {
        return ((Object)this._attributes).equals(obj);
    }

    public int hashCode() {
        return ((Object)this._attributes).hashCode();
    }
}

