/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.commons.converter;

import javax.faces.application.FacesMessage;
import javax.faces.component.PartialStateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.apache.myfaces.commons.util.MessageUtils;

public class EnumConverter
implements Converter,
PartialStateHolder {
    public static final String CONVERTER_ID = "org.apache.myfaces.commons.converter.Enum";
    public static final String ENUM_ID = "org.apache.myfaces.commons.converter.EnumConverter.ENUM";
    public static final String ENUM_NO_CLASS_ID = "org.apache.myfaces.commons.converter.EnumConverter.ENUM_NO_CLASS";
    public static final String ENUM_NO_ENUM_CLASS = "org.apache.myfaces.commons.converter.EnumConverter.ENUM_NO_ENUM_CLASS";
    public static final String SEPARATOR = "#";
    private Class targetClass;
    private boolean isTransient = false;
    private boolean _initialStateMarked = false;

    public EnumConverter() {
    }

    public EnumConverter(Class targetClass) {
        if (!targetClass.isEnum()) {
            throw new IllegalArgumentException("targetClass for EnumConverter must be an Enum");
        }
        this.targetClass = targetClass;
    }

    public String getAsString(FacesContext facesContext, UIComponent uiComponent, Object value) throws ConverterException {
        if (facesContext == null) {
            throw new NullPointerException("facesContext can not be null");
        }
        if (uiComponent == null) {
            throw new NullPointerException("uiComponent can not be null");
        }
        if (value == null) {
            return "";
        }
        Class<?> converterClass = null;
        String idPrefix = "";
        if (this.targetClass != null) {
            converterClass = this.targetClass;
        } else if (value.getClass().isEnum()) {
            converterClass = value.getClass();
            idPrefix = value.getClass().getName() + SEPARATOR;
        } else if (value.getClass().getDeclaringClass() != null && value.getClass().getDeclaringClass().isEnum()) {
            converterClass = value.getClass().getDeclaringClass();
            idPrefix = value.getClass().getDeclaringClass().getName() + SEPARATOR;
        }
        if (converterClass == null || this.targetClass != null) {
            this.checkTargetClass(facesContext, uiComponent, value, converterClass);
        }
        for (Object enumConstant : converterClass.getEnumConstants()) {
            if (enumConstant != value) continue;
            return idPrefix + ((Enum)enumConstant).name();
        }
        return value.toString();
    }

    public Object getAsObject(FacesContext facesContext, UIComponent uiComponent, String value) throws ConverterException {
        if (facesContext == null) {
            throw new NullPointerException("facesContext");
        }
        if (uiComponent == null) {
            throw new NullPointerException("uiComponent");
        }
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() == 0) {
            return null;
        }
        Class<?> converterClass = null;
        String enumName = null;
        if (this.targetClass != null) {
            enumName = value;
            converterClass = this.targetClass;
        } else if (value.indexOf(SEPARATOR) > 0) {
            int index = value.indexOf(SEPARATOR);
            if (index < value.length() - 2) {
                String className = value.substring(0, index);
                enumName = value.substring(index + 1);
                try {
                    converterClass = Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            if (enumName == null || enumName.length() == 0) {
                return null;
            }
        }
        if (converterClass == null) {
            this.checkTargetClass(facesContext, uiComponent, value, converterClass);
        }
        try {
            return Enum.valueOf(converterClass, enumName);
        }
        catch (IllegalArgumentException e) {
            Object[] params = new Object[]{value, this.firstConstantOfEnum(), MessageUtils.getLabel((FacesContext)facesContext, (UIComponent)uiComponent)};
            throw new ConverterException(MessageUtils.getMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)ENUM_ID, (Object[])params));
        }
    }

    private void checkTargetClass(FacesContext facesContext, UIComponent uiComponent, Object value, Class converterClass) {
        if (converterClass == null) {
            Object[] params = new Object[]{value, MessageUtils.getLabel((FacesContext)facesContext, (UIComponent)uiComponent)};
            throw new ConverterException(MessageUtils.getMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)ENUM_NO_CLASS_ID, (Object[])params));
        }
        if (!converterClass.isEnum()) {
            Object[] params = new Object[]{value, MessageUtils.getLabel((FacesContext)facesContext, (UIComponent)uiComponent)};
            throw new ConverterException(MessageUtils.getMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)ENUM_NO_ENUM_CLASS, (Object[])params));
        }
    }

    private String firstConstantOfEnum() {
        T[] enumConstants = this.targetClass.getEnumConstants();
        if (enumConstants.length != 0) {
            return enumConstants[0].toString();
        }
        return "";
    }

    public void restoreState(FacesContext context, Object state) {
        if (state != null) {
            this.targetClass = (Class)state;
        }
    }

    public Object saveState(FacesContext context) {
        if (!this.initialStateMarked()) {
            return this.targetClass;
        }
        return null;
    }

    public void setTransient(boolean newTransientValue) {
        this.isTransient = newTransientValue;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public Class getTargetClass() {
        return this.targetClass;
    }

    public void setTargetClass(Class targetClass) {
        this.targetClass = targetClass;
        this.clearInitialState();
    }

    public void clearInitialState() {
        this._initialStateMarked = false;
    }

    public boolean initialStateMarked() {
        return this._initialStateMarked;
    }

    public void markInitialState() {
        this._initialStateMarked = true;
    }
}

