/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.commons.converter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ValueExpression;
import javax.faces.component.StateHelper;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import org.apache.myfaces.commons.converter.ConverterBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class _DeltaStateHelper
implements StateHelper {
    private ConverterBase _component;
    private Map<Serializable, Object> _fullState;
    private Map<Serializable, Object> _deltas;
    private boolean _transient = false;

    public _DeltaStateHelper(ConverterBase component) {
        this._component = component;
        this._fullState = new HashMap<Serializable, Object>();
        this._deltas = null;
    }

    private boolean _createDeltas() {
        if (this.isInitialStateMarked()) {
            if (this._deltas == null) {
                this._deltas = new HashMap<Serializable, Object>(2);
            }
            return true;
        }
        return false;
    }

    protected boolean isInitialStateMarked() {
        return this._component.initialStateMarked();
    }

    public void add(Serializable key, Object value) {
        InternalList fullListValues;
        if (this._createDeltas()) {
            InternalDeltaListMap<Object, Boolean> deltaListMapValues = (InternalDeltaListMap<Object, Boolean>)this._deltas.get(key);
            if (deltaListMapValues == null) {
                deltaListMapValues = new InternalDeltaListMap<Object, Boolean>(3);
                this._deltas.put(key, deltaListMapValues);
            }
            deltaListMapValues.put(value, Boolean.TRUE);
        }
        if ((fullListValues = (InternalList)this._fullState.get(key)) == null) {
            fullListValues = new InternalList(3);
            this._fullState.put(key, fullListValues);
        }
        fullListValues.add(value);
    }

    public Object eval(Serializable key) {
        Object returnValue = this._fullState.get(key);
        if (returnValue != null) {
            return returnValue;
        }
        ValueExpression expression = this._component.getValueExpression(key.toString());
        if (expression != null) {
            return expression.getValue(this._component.getFacesContext().getELContext());
        }
        return null;
    }

    public Object eval(Serializable key, Object defaultValue) {
        Object returnValue = this._fullState.get(key);
        if (returnValue != null) {
            return returnValue;
        }
        ValueExpression expression = this._component.getValueExpression(key.toString());
        if (expression != null) {
            return expression.getValue(this._component.getFacesContext().getELContext());
        }
        return defaultValue;
    }

    public Object get(Serializable key) {
        return this._fullState.get(key);
    }

    public Object put(Serializable key, Object value) {
        Object returnValue = null;
        if (this._createDeltas()) {
            if (this._deltas.containsKey(key)) {
                returnValue = this._deltas.put(key, value);
                this._fullState.put(key, value);
            } else if (value == null && !this._fullState.containsKey(key)) {
                returnValue = null;
            } else {
                this._deltas.put(key, value);
                returnValue = this._fullState.put(key, value);
            }
        } else {
            returnValue = this._fullState.put(key, value);
        }
        return returnValue;
    }

    public Object put(Serializable key, String mapKey, Object value) {
        InternalMap<String, Object> mapValues;
        boolean returnSet = false;
        Object returnValue = null;
        if (this._createDeltas()) {
            mapValues = (InternalMap<String, Object>)this._deltas.get(key);
            if (mapValues == null) {
                mapValues = new InternalMap<String, Object>();
                this._deltas.put(key, mapValues);
            }
            if (mapValues.containsKey(mapKey)) {
                returnValue = mapValues.put(mapKey, value);
                returnSet = true;
            } else {
                mapValues.put(mapKey, value);
            }
        }
        if ((mapValues = (Map)this._fullState.get(key)) == null) {
            mapValues = new InternalMap();
            this._fullState.put(key, mapValues);
        }
        if (returnSet) {
            mapValues.put(mapKey, value);
        } else {
            returnValue = mapValues.put(mapKey, value);
        }
        return returnValue;
    }

    public Object remove(Serializable key) {
        Object returnValue = null;
        if (this._createDeltas()) {
            if (this._deltas.containsKey(key)) {
                returnValue = this._deltas.put(key, null);
                this._fullState.remove(key);
            } else {
                this._deltas.put(key, null);
                returnValue = this._fullState.remove(key);
            }
        } else {
            returnValue = this._fullState.remove(key);
        }
        return returnValue;
    }

    public Object remove(Serializable key, Object valueOrKey) {
        Object collectionOrMap = this._fullState.get(key);
        Object returnValue = null;
        if (collectionOrMap instanceof InternalMap) {
            if (this._createDeltas()) {
                returnValue = _DeltaStateHelper._removeValueOrKeyFromMap(this._deltas, key, valueOrKey, true);
                _DeltaStateHelper._removeValueOrKeyFromMap(this._fullState, key, valueOrKey, false);
            } else {
                returnValue = _DeltaStateHelper._removeValueOrKeyFromMap(this._fullState, key, valueOrKey, false);
            }
        } else if (collectionOrMap instanceof InternalList) {
            if (this._createDeltas()) {
                returnValue = _DeltaStateHelper._removeValueOrKeyFromCollectionDelta(this._deltas, key, valueOrKey);
                _DeltaStateHelper._removeValueOrKeyFromCollection(this._fullState, key, valueOrKey);
            } else {
                returnValue = _DeltaStateHelper._removeValueOrKeyFromCollection(this._fullState, key, valueOrKey);
            }
        }
        return returnValue;
    }

    private static Object _removeValueOrKeyFromCollectionDelta(Map<Serializable, Object> stateMap, Serializable key, Object valueOrKey) {
        Object returnValue = null;
        Map c = (Map)stateMap.get(key);
        if (c != null) {
            if (c.containsKey(valueOrKey)) {
                returnValue = valueOrKey;
            }
            c.put(valueOrKey, Boolean.FALSE);
        }
        return returnValue;
    }

    private static Object _removeValueOrKeyFromCollection(Map<Serializable, Object> stateMap, Serializable key, Object valueOrKey) {
        Object returnValue = null;
        Collection c = (Collection)stateMap.get(key);
        if (c != null) {
            if (c.remove(valueOrKey)) {
                returnValue = valueOrKey;
            }
            if (c.isEmpty()) {
                stateMap.remove(key);
            }
        }
        return returnValue;
    }

    private static Object _removeValueOrKeyFromMap(Map<Serializable, Object> stateMap, Serializable key, Object valueOrKey, boolean delta) {
        if (valueOrKey == null) {
            return null;
        }
        Object returnValue = null;
        Map map = (Map)stateMap.get(key);
        if (map != null) {
            returnValue = delta ? map.put((String)valueOrKey, null) : map.remove(valueOrKey);
            if (map.isEmpty()) {
                stateMap.put(key, null);
            }
        }
        return returnValue;
    }

    public boolean isTransient() {
        return this._transient;
    }

    public Object saveState(FacesContext context) {
        Map<Serializable, Object> serializableMap;
        Map<Serializable, Object> map = serializableMap = this.isInitialStateMarked() ? this._deltas : this._fullState;
        if (serializableMap == null || serializableMap.size() == 0) {
            return null;
        }
        Object[] retArr = new Object[serializableMap.entrySet().size() * 2];
        Iterator<Map.Entry<Serializable, Object>> it = serializableMap.entrySet().iterator();
        int cnt = 0;
        while (it.hasNext()) {
            Object savedValue;
            Map.Entry<Serializable, Object> entry = it.next();
            retArr[cnt] = entry.getKey();
            Object value = entry.getValue();
            retArr[cnt + 1] = value instanceof StateHolder || value instanceof List || !(value instanceof Serializable) ? (savedValue = ConverterBase.saveAttachedState(context, value)) : value;
            cnt += 2;
        }
        return retArr;
    }

    public void restoreState(FacesContext context, Object state) {
        if (state == null) {
            return;
        }
        Object[] serializedState = (Object[])state;
        if (!this.isInitialStateMarked() && !this._fullState.isEmpty()) {
            this._fullState.clear();
            if (this._deltas != null) {
                this._deltas.clear();
            }
        }
        for (int cnt = 0; cnt < serializedState.length; cnt += 2) {
            Serializable key = (Serializable)serializedState[cnt];
            Object savedValue = ConverterBase.restoreAttachedState(context, serializedState[cnt + 1]);
            if (this.isInitialStateMarked()) {
                if (savedValue instanceof InternalDeltaListMap) {
                    for (Map.Entry mapEntry : ((Map)savedValue).entrySet()) {
                        boolean addOrRemove = (Boolean)mapEntry.getValue();
                        if (addOrRemove) {
                            this.add(key, mapEntry.getKey());
                            continue;
                        }
                        this.remove(key, mapEntry.getKey());
                    }
                    continue;
                }
                if (savedValue instanceof InternalMap) {
                    for (Map.Entry mapEntry : ((Map)savedValue).entrySet()) {
                        this.put(key, (String)mapEntry.getKey(), mapEntry.getValue());
                    }
                    continue;
                }
                this.put(key, savedValue);
                continue;
            }
            this.put(key, savedValue);
        }
    }

    public void setTransient(boolean transientValue) {
        this._transient = transientValue;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class InternalList<T>
    extends ArrayList<T>
    implements StateHolder {
        public InternalList() {
        }

        public InternalList(Collection<? extends T> c) {
            super(c);
        }

        public InternalList(int initialSize) {
            super(initialSize);
        }

        public boolean isTransient() {
            return false;
        }

        public void setTransient(boolean newTransientValue) {
        }

        public void restoreState(FacesContext context, Object state) {
            Object[] listAsArr;
            for (Object elem : listAsArr = (Object[])state) {
                this.add(ConverterBase.restoreAttachedState(context, elem));
            }
        }

        public Object saveState(FacesContext context) {
            Object[] values = new Object[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                Object value = this.get(i);
                values[i] = value instanceof StateHolder || value instanceof List || !(value instanceof Serializable) ? ConverterBase.saveAttachedState(context, value) : value;
            }
            return values;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class InternalDeltaListMap<K, V>
    extends InternalMap<K, V> {
        public InternalDeltaListMap() {
        }

        public InternalDeltaListMap(int initialCapacity, float loadFactor) {
            super(initialCapacity, loadFactor);
        }

        public InternalDeltaListMap(int initialSize) {
            super(initialSize);
        }

        public InternalDeltaListMap(Map<? extends K, ? extends V> m) {
            super(m);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class InternalMap<K, V>
    extends HashMap<K, V>
    implements StateHolder {
        public InternalMap() {
        }

        public InternalMap(int initialCapacity, float loadFactor) {
            super(initialCapacity, loadFactor);
        }

        public InternalMap(Map<? extends K, ? extends V> m) {
            super(m);
        }

        public InternalMap(int initialSize) {
            super(initialSize);
        }

        public boolean isTransient() {
            return false;
        }

        public void setTransient(boolean newTransientValue) {
        }

        public void restoreState(FacesContext context, Object state) {
            Object[] listAsMap = (Object[])state;
            for (int cnt = 0; cnt < listAsMap.length; cnt += 2) {
                this.put(listAsMap[cnt], ConverterBase.restoreAttachedState(context, listAsMap[cnt + 1]));
            }
        }

        public Object saveState(FacesContext context) {
            int cnt = 0;
            Object[] mapArr = new Object[this.size() * 2];
            for (Map.Entry entry : this.entrySet()) {
                mapArr[cnt] = entry.getKey();
                Object value = entry.getValue();
                mapArr[cnt + 1] = value instanceof StateHolder || value instanceof List || !(value instanceof Serializable) ? ConverterBase.saveAttachedState(context, value) : value;
                cnt += 2;
            }
            return mapArr;
        }
    }
}

