/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.commons.validator;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import org.apache.commons.validator.UrlValidator;
import org.apache.myfaces.commons.validator.ValidatorBase;

public abstract class AbstractUrlValidator
extends ValidatorBase {
    public static final String VALIDATOR_ID = "org.apache.myfaces.commons.validator.Url";
    public static final String URL_MESSAGE_ID = "org.apache.myfaces.commons.validator.Url.INVALID";

    public void validate(FacesContext facesContext, UIComponent uiComponent, Object value) throws ValidatorException {
        if (facesContext == null) {
            throw new NullPointerException("facesContext");
        }
        if (uiComponent == null) {
            throw new NullPointerException("uiComponent");
        }
        if (value == null) {
            return;
        }
        UrlValidator urlValidator = this.initValidator();
        if (!urlValidator.isValid(value.toString())) {
            Object[] args = new Object[]{value.toString()};
            throw new ValidatorException(this.getFacesMessage(URL_MESSAGE_ID, args));
        }
    }

    private UrlValidator initValidator() {
        int options = 0;
        if (this.isAllow2Slashes()) {
            options |= 2;
        }
        if (this.isAllowAllSchemas()) {
            options |= 1;
        }
        String[] schemesList = this.getSchemesList();
        UrlValidator urlValidator = null;
        urlValidator = schemesList == null ? new UrlValidator(options) : new UrlValidator(schemesList, options);
        return urlValidator;
    }

    private String[] getSchemesList() {
        if (this.getSchemes() == null) {
            return null;
        }
        String[] list = this.getSchemes().split(",");
        String[] resp = new String[list.length];
        for (int i = 0; i < list.length; ++i) {
            resp[i] = list[i].trim();
        }
        return resp;
    }

    public abstract void setSchemes(String var1);

    public abstract String getSchemes();

    public abstract void setAllow2Slashes(boolean var1);

    public abstract boolean isAllow2Slashes();

    public abstract void setAllowAllSchemas(boolean var1);

    public abstract boolean isAllowAllSchemas();
}

