/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.protocol;

import org.apache.vysper.xmpp.parser.ParsingErrorCondition;
import org.apache.vysper.xmpp.parser.ParsingException;
import org.apache.vysper.xmpp.protocol.ProtocolException;
import org.apache.vysper.xmpp.protocol.ResponseStanzaContainer;
import org.apache.vysper.xmpp.protocol.StreamErrorCondition;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.server.XMPPVersion;
import org.apache.vysper.xmpp.server.response.ServerErrorResponses;
import org.apache.vysper.xmpp.server.response.ServerResponses;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.StanzaErrorCondition;
import org.apache.vysper.xmpp.stanza.StanzaErrorType;
import org.apache.vysper.xmpp.stanza.XMPPCoreStanza;

public class ResponseWriter {
    public static void writeUnsupportedStanzaError(SessionContext sessionContext) {
        Stanza errorStanza = ServerErrorResponses.getStreamError(StreamErrorCondition.UNSUPPORTED_STANZA_TYPE, sessionContext.getXMLLang(), "service unavailable at this session state", null);
        Stanza streamOpener = new ServerResponses().getStreamOpenerForError(false, sessionContext.getServerJID(), XMPPVersion.VERSION_1_0, errorStanza);
        ResponseWriter.writeErrorAndClose(sessionContext, streamOpener);
    }

    public static void writeResponse(SessionContext sessionContext, ResponseStanzaContainer responseStanzaContainer) {
        Stanza responseStanza = responseStanzaContainer.getResponseStanza();
        ResponseWriter.writeResponse(sessionContext, responseStanza);
    }

    public static void writeResponse(SessionContext sessionContext, Stanza responseStanza) {
        sessionContext.getResponseWriter().write(responseStanza);
    }

    public static void handleProtocolError(ProtocolException protocolException, SessionContext sessionContext, Stanza receivedStanza) {
        Stanza errorStanza = null;
        if (protocolException != null) {
            errorStanza = protocolException.getErrorStanza();
        }
        if (errorStanza == null) {
            errorStanza = ServerErrorResponses.getStreamError(StreamErrorCondition.BAD_FORMAT, sessionContext.getXMLLang(), "could not process incoming stanza", receivedStanza);
        }
        ResponseWriter.writeErrorAndClose(sessionContext, errorStanza);
    }

    public void handleUnsupportedStanzaType(SessionContext sessionContext, Stanza receivedStanza) {
        Stanza errorStanza = ServerErrorResponses.getStreamError(StreamErrorCondition.UNSUPPORTED_STANZA_TYPE, sessionContext.getXMLLang(), "could not process incoming stanza", receivedStanza);
        ResponseWriter.writeErrorAndClose(sessionContext, errorStanza);
    }

    public void handleNotAuthorized(SessionContext sessionContext, Stanza receivedStanza) {
        Stanza errorStanza = ServerErrorResponses.getStreamError(StreamErrorCondition.NOT_AUTHORIZED, sessionContext.getXMLLang(), "could not process incoming stanza", receivedStanza);
        ResponseWriter.writeErrorAndClose(sessionContext, errorStanza);
    }

    public void handleWrongFromJID(SessionContext sessionContext, Stanza receivedStanza) {
        XMPPCoreStanza receivedCoreStanza = XMPPCoreStanza.getWrapper(receivedStanza);
        if (receivedCoreStanza == null) {
            this.handleNotAuthorized(sessionContext, receivedStanza);
            return;
        }
        Stanza errorStanza = ServerErrorResponses.getStanzaError(StanzaErrorCondition.UNKNOWN_SENDER, receivedCoreStanza, StanzaErrorType.MODIFY, "from attribute does not match authorized entity", null, null);
        ResponseWriter.writeResponse(sessionContext, errorStanza);
    }

    public void handleParsingException(SessionContext sessionContext, ParsingException e) {
        if (e.getErrorCondition() != ParsingErrorCondition.BAD_FORMAT) {
            throw new RuntimeException("cannot handle this error condition yet");
        }
        Stanza errorStanza = ServerErrorResponses.getStreamError(StreamErrorCondition.BAD_FORMAT, sessionContext.getXMLLang(), "could not parse incoming stanza", null);
        ResponseWriter.writeErrorAndClose(sessionContext, errorStanza);
    }

    public static void writeErrorAndClose(SessionContext sessionContext, Stanza errorStanza) {
        ResponseWriter.writeResponse(sessionContext, errorStanza);
        sessionContext.endSession(SessionContext.SessionTerminationCause.STREAM_ERROR);
    }
}

