/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.storage.jcr.user;

import javax.jcr.Node;
import javax.jcr.Property;
import org.apache.vysper.storage.jcr.JcrStorage;
import org.apache.vysper.storage.jcr.JcrStorageException;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.addressing.EntityFormatException;
import org.apache.vysper.xmpp.addressing.EntityImpl;
import org.apache.vysper.xmpp.authorization.AccountCreationException;
import org.apache.vysper.xmpp.authorization.AccountManagement;
import org.apache.vysper.xmpp.authorization.UserAuthorization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrUserManagement
implements UserAuthorization,
AccountManagement {
    final Logger logger = LoggerFactory.getLogger(JcrUserManagement.class);
    protected JcrStorage jcrStorage;
    private static final String CREDENTIALS_NAMESPACE = "vysper_internal_credentials";

    public JcrUserManagement(JcrStorage jcrStorage) {
        this.jcrStorage = jcrStorage;
    }

    public boolean verifyCredentials(Entity jid, String passwordCleartext, Object credentials) {
        if (passwordCleartext == null) {
            return false;
        }
        try {
            Node credentialsNode = this.jcrStorage.getEntityNode(jid, CREDENTIALS_NAMESPACE, false);
            if (credentialsNode == null) {
                return false;
            }
            Property property = credentialsNode.getProperty("password");
            if (property == null) {
                return false;
            }
            String password = property.getValue().getString();
            return passwordCleartext.equals(password);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean verifyCredentials(String username, String passwordCleartext, Object credentials) {
        try {
            return this.verifyCredentials(EntityImpl.parse(username), passwordCleartext, credentials);
        }
        catch (EntityFormatException e) {
            return false;
        }
    }

    public boolean verifyAccountExists(Entity jid) {
        try {
            return this.jcrStorage.getEntityNode(jid, CREDENTIALS_NAMESPACE, false) != null;
        }
        catch (JcrStorageException e) {
            return false;
        }
    }

    public void addUser(Entity username, String password) throws AccountCreationException {
        try {
            if (this.jcrStorage.getEntityNode(username, CREDENTIALS_NAMESPACE, false) != null) {
                throw new AccountCreationException("account already exists: " + username.getFullQualifiedName());
            }
        }
        catch (JcrStorageException e) {
            throw new AccountCreationException("account exists check failed for " + username.getFullQualifiedName(), e);
        }
        try {
            Node credentialsNode = this.jcrStorage.getEntityNode(username, CREDENTIALS_NAMESPACE, true);
            credentialsNode.setProperty("password", password);
            credentialsNode.save();
            this.logger.info("JCR node created: " + credentialsNode);
        }
        catch (Exception e) {
            throw new AccountCreationException("failed to create the account set credentials", e);
        }
    }

    public void changePassword(Entity username, String password) throws AccountCreationException {
        try {
            Node credentialsNode = this.jcrStorage.getEntityNode(username, CREDENTIALS_NAMESPACE, false);
            credentialsNode.setProperty("password", password);
            credentialsNode.save();
            this.logger.info("JCR password changed: " + credentialsNode);
        }
        catch (Exception e) {
            throw new AccountCreationException("failed to create the account set credentials", e);
        }
    }
}

