/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.plugin.descriptor.lifecycle;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.plugin.descriptor.lifecycle.Execution;
import org.apache.maven.api.plugin.descriptor.lifecycle.ImmutableCollections;
import org.apache.maven.api.xml.XmlNode;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Phase
implements Serializable {
    final String id;
    final String executionPoint;
    final int priority;
    final List<Execution> executions;
    final XmlNode configuration;

    protected Phase(Builder builder) {
        String string = builder.id != null ? builder.id : (this.id = builder.base != null ? builder.base.id : null);
        String string2 = builder.executionPoint != null ? builder.executionPoint : (this.executionPoint = builder.base != null ? builder.base.executionPoint : null);
        int n = builder.priority != null ? builder.priority : (this.priority = builder.base != null ? builder.base.priority : 0);
        this.executions = ImmutableCollections.copy(builder.executions != null ? builder.executions : (builder.base != null ? builder.base.executions : null));
        this.configuration = builder.configuration != null ? builder.configuration : (builder.base != null ? builder.base.configuration : null);
    }

    public String getId() {
        return this.id;
    }

    public String getExecutionPoint() {
        return this.executionPoint;
    }

    public int getPriority() {
        return this.priority;
    }

    @Nonnull
    public List<Execution> getExecutions() {
        return this.executions;
    }

    public XmlNode getConfiguration() {
        return this.configuration;
    }

    @Nonnull
    public Builder with() {
        return Phase.newBuilder(this);
    }

    @Nonnull
    public Phase withId(String id) {
        return Phase.newBuilder(this, true).id(id).build();
    }

    @Nonnull
    public Phase withExecutionPoint(String executionPoint) {
        return Phase.newBuilder(this, true).executionPoint(executionPoint).build();
    }

    @Nonnull
    public Phase withPriority(int priority) {
        return Phase.newBuilder(this, true).priority(priority).build();
    }

    @Nonnull
    public Phase withExecutions(Collection<Execution> executions) {
        return Phase.newBuilder(this, true).executions(executions).build();
    }

    @Nonnull
    public Phase withConfiguration(XmlNode configuration) {
        return Phase.newBuilder(this, true).configuration(configuration).build();
    }

    @Nonnull
    public static Phase newInstance() {
        return Phase.newInstance(true);
    }

    @Nonnull
    public static Phase newInstance(boolean withDefaults) {
        return Phase.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Phase.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Phase from) {
        return Phase.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Phase from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public String getEffectiveId() {
        if (this.executionPoint == null) {
            if (this.priority == 0) {
                return this.id;
            }
            return this.id + "[" + this.priority + "]";
        }
        if (this.priority == 0) {
            return this.executionPoint + ":" + this.id;
        }
        return this.executionPoint + ":" + this.id + "[" + this.priority + "]";
    }

    @NotThreadSafe
    public static class Builder {
        Phase base;
        String id;
        String executionPoint;
        Integer priority;
        Collection<Execution> executions;
        XmlNode configuration;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
                this.priority = 0;
            }
        }

        protected Builder(Phase base, boolean forceCopy) {
            if (forceCopy) {
                this.id = base.id;
                this.executionPoint = base.executionPoint;
                this.priority = base.priority;
                this.executions = base.executions;
                this.configuration = base.configuration;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder executionPoint(String executionPoint) {
            this.executionPoint = executionPoint;
            return this;
        }

        @Nonnull
        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        @Nonnull
        public Builder executions(Collection<Execution> executions) {
            this.executions = executions;
            return this;
        }

        @Nonnull
        public Builder configuration(XmlNode configuration) {
            this.configuration = configuration;
            return this;
        }

        @Nonnull
        public Phase build() {
            if (!(this.base == null || this.id != null && this.id != this.base.id || this.executionPoint != null && this.executionPoint != this.base.executionPoint || this.priority != null && this.priority != this.base.priority || this.executions != null && this.executions != this.base.executions || this.configuration != null && this.configuration != this.base.configuration)) {
                return this.base;
            }
            return new Phase(this);
        }
    }
}

