/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.jcas.cas;

import org.apache.uima.cas.DoubleArrayFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JCasRegistry;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.cas.TOP_Type;

public final class DoubleArray
extends TOP
implements DoubleArrayFS {
    public static final int typeIndexID;
    public static final int type;

    @Override
    public int getTypeIndexID() {
        return typeIndexID;
    }

    private DoubleArray() {
    }

    public DoubleArray(int addr, TOP_Type type) {
        super(addr, type);
    }

    public DoubleArray(JCas jcas, int length) {
        this(jcas.getLowLevelCas().ll_createDoubleArray(length), jcas.getType(typeIndexID));
    }

    @Override
    public double get(int i) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, i);
        return this.jcasType.ll_cas.ll_getDoubleArrayValue(this.addr, i);
    }

    @Override
    public void set(int i, double v) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, i);
        this.jcasType.ll_cas.ll_setDoubleArrayValue(this.addr, i, v);
    }

    @Override
    public void copyFromArray(double[] src, int srcOffset, int destOffset, int length) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, destOffset, length);
        for (int i = 0; i < length; ++i) {
            this.jcasType.ll_cas.ll_setDoubleArrayValue(this.addr, i + destOffset, src[i + srcOffset]);
        }
    }

    @Override
    public void copyToArray(int srcOffset, double[] dest, int destOffset, int length) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, srcOffset, length);
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = this.jcasType.ll_cas.ll_getDoubleArrayValue(this.addr, i + srcOffset);
        }
    }

    @Override
    public double[] toArray() {
        int size = this.size();
        double[] outArray = new double[size];
        this.copyToArray(0, outArray, 0, size);
        return outArray;
    }

    @Override
    public int size() {
        return this.jcasType.casImpl.ll_getArraySize(this.addr);
    }

    @Override
    public void copyToArray(int srcOffset, String[] dest, int destOffset, int length) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, srcOffset, length);
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = Double.toString(this.jcasType.ll_cas.ll_getDoubleArrayValue(this.addr, i + srcOffset));
        }
    }

    @Override
    public void copyFromArray(String[] src, int srcOffset, int destOffset, int length) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, destOffset, length);
        for (int i = 0; i < length; ++i) {
            this.jcasType.ll_cas.ll_setDoubleArrayValue(this.addr, i + destOffset, Double.parseDouble(src[i + srcOffset]));
        }
    }

    @Override
    public String[] toStringArray() {
        int size = this.size();
        String[] strArray = new String[size];
        this.copyToArray(0, strArray, 0, size);
        return strArray;
    }

    static {
        type = typeIndexID = JCasRegistry.register(DoubleArray.class);
    }
}

