/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.payloads.DelimitedPayloadTokenFilter;
import org.apache.lucene.analysis.payloads.FloatEncoder;
import org.apache.lucene.analysis.payloads.IdentityEncoder;
import org.apache.lucene.analysis.payloads.IntegerEncoder;
import org.apache.lucene.analysis.payloads.PayloadEncoder;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.settings.IndexSettings;

public class DelimitedPayloadTokenFilterFactory
extends AbstractTokenFilterFactory {
    static final char DEFAULT_DELIMITER = '|';
    static final PayloadEncoder DEFAULT_ENCODER = new FloatEncoder();
    static final String ENCODING = "encoding";
    static final String DELIMITER = "delimiter";
    char delimiter;
    PayloadEncoder encoder;

    @Inject
    public DelimitedPayloadTokenFilterFactory(Index index, @IndexSettings Settings indexSettings, Environment env, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettings, name, settings);
        String delimiterConf = settings.get(DELIMITER);
        this.delimiter = delimiterConf != null ? delimiterConf.charAt(0) : (char)124;
        if (settings.get(ENCODING) != null) {
            if (settings.get(ENCODING).equals("float")) {
                this.encoder = new FloatEncoder();
            } else if (settings.get(ENCODING).equals("int")) {
                this.encoder = new IntegerEncoder();
            } else if (settings.get(ENCODING).equals("identity")) {
                this.encoder = new IdentityEncoder();
            }
        } else {
            this.encoder = DEFAULT_ENCODER;
        }
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        DelimitedPayloadTokenFilter filter = new DelimitedPayloadTokenFilter(tokenStream, this.delimiter, this.encoder);
        return filter;
    }
}

