/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/

package org.apache.kylin.rest.msg;

import org.apache.kylin.common.threadlocal.InternalThreadLocal;

/**
 * Created by luwei on 17-4-12.
 */
public class MsgPicker {
    private static InternalThreadLocal<Message> msg = new InternalThreadLocal<Message>();

    public static void setMsg(String lang) {
        if ("cn".equals(lang))
            msg.set(CnMessage.getInstance());
        else
            msg.set(Message.getInstance());
    }

    public static Message getMsg() {
        Message ret = msg.get();
        if (ret == null) { // use English by default
            ret = Message.getInstance();
            msg.set(Message.getInstance());
        }
        return ret;
    }
}
