/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol.ascii;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import net.spy.memcached.KeyUtil;
import net.spy.memcached.ops.GetAndTouchOperation;
import net.spy.memcached.ops.GetOperation;
import net.spy.memcached.ops.GetlOperation;
import net.spy.memcached.ops.GetsOperation;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.StatusCode;
import net.spy.memcached.protocol.ascii.OperationImpl;
import net.spy.memcached.protocol.ascii.OperationReadType;
import net.spy.memcached.util.StringUtils;

public abstract class BaseGetOpImpl
extends OperationImpl {
    private static final OperationStatus END = new OperationStatus(true, "END", StatusCode.SUCCESS);
    private static final OperationStatus NOT_FOUND = new OperationStatus(false, "NOT_FOUND", StatusCode.ERR_NOT_FOUND);
    private static final OperationStatus LOCK_ERROR = new OperationStatus(false, "LOCK_ERROR", StatusCode.ERR_TEMP_FAIL);
    private static final byte[] RN_BYTES = "\r\n".getBytes();
    private final String cmd;
    private final Collection<String> keys;
    private String currentKey = null;
    protected final int exp;
    private final byte[] expBytes;
    private long casValue = 0L;
    private int currentFlags = 0;
    private byte[] data = null;
    private int readOffset = 0;
    private byte lookingFor = 0;
    private boolean hasValue;

    public BaseGetOpImpl(String c, OperationCallback cb, Collection<String> k) {
        super(cb);
        this.cmd = c;
        this.keys = k;
        this.exp = 0;
        this.expBytes = null;
        this.hasValue = false;
    }

    public BaseGetOpImpl(String c, int e, OperationCallback cb, String k) {
        super(cb);
        this.cmd = c;
        this.keys = Collections.singleton(k);
        this.exp = e;
        this.expBytes = String.valueOf(e).getBytes();
        this.hasValue = false;
    }

    public final Collection<String> getKeys() {
        return this.keys;
    }

    @Override
    public final void handleLine(String line) {
        if (line.equals("END")) {
            this.getLogger().debug("Get complete!");
            if (this.hasValue) {
                this.getCallback().receivedStatus(END);
            } else {
                this.getCallback().receivedStatus(NOT_FOUND);
            }
            this.transitionState(OperationState.COMPLETE);
            this.data = null;
        } else if (line.startsWith("VALUE ")) {
            this.getLogger().debug("Got line %s", line);
            String[] stuff = line.split(" ");
            assert (stuff[0].equals("VALUE"));
            this.currentKey = stuff[1];
            this.currentFlags = Integer.parseInt(stuff[2]);
            this.data = new byte[Integer.parseInt(stuff[3])];
            if (stuff.length > 4) {
                this.casValue = Long.parseLong(stuff[4]);
            }
            this.readOffset = 0;
            this.hasValue = true;
            this.getLogger().debug("Set read type to data");
            this.setReadType(OperationReadType.DATA);
        } else if (line.equals("LOCK_ERROR")) {
            this.getCallback().receivedStatus(LOCK_ERROR);
            this.transitionState(OperationState.COMPLETE);
        } else assert (false) : "Unknown line type: " + line;
    }

    @Override
    public final void handleRead(ByteBuffer b) {
        assert (this.currentKey != null);
        assert (this.data != null);
        assert (this.readOffset <= this.data.length) : "readOffset is " + this.readOffset + " data.length is " + this.data.length;
        this.getLogger().debug("readOffset: %d, length: %d", this.readOffset, this.data.length);
        if (this.lookingFor == 0) {
            int toRead = this.data.length - this.readOffset;
            int available = b.remaining();
            toRead = Math.min(toRead, available);
            this.getLogger().debug("Reading %d bytes", toRead);
            b.get(this.data, this.readOffset, toRead);
            this.readOffset += toRead;
        }
        if (this.readOffset == this.data.length && this.lookingFor == 0) {
            OperationCallback gcb;
            OperationCallback cb = this.getCallback();
            if (cb instanceof GetOperation.Callback) {
                gcb = (GetOperation.Callback)cb;
                gcb.gotData(this.currentKey, this.currentFlags, this.data);
            } else if (cb instanceof GetsOperation.Callback) {
                gcb = (GetsOperation.Callback)cb;
                gcb.gotData(this.currentKey, this.currentFlags, this.casValue, this.data);
            } else if (cb instanceof GetlOperation.Callback) {
                gcb = (GetlOperation.Callback)cb;
                gcb.gotData(this.currentKey, this.currentFlags, this.casValue, this.data);
            } else if (cb instanceof GetAndTouchOperation.Callback) {
                gcb = (GetAndTouchOperation.Callback)cb;
                gcb.gotData(this.currentKey, this.currentFlags, this.casValue, this.data);
            } else {
                throw new ClassCastException("Couldn't convert " + cb + "to a relevent op");
            }
            this.lookingFor = (byte)13;
        }
        if (this.lookingFor != 0 && b.hasRemaining()) {
            do {
                byte tmp = b.get();
                assert (tmp == this.lookingFor) : "Expecting " + this.lookingFor + ", got " + (char)tmp;
                switch (this.lookingFor) {
                    case 13: {
                        this.lookingFor = (byte)10;
                        break;
                    }
                    case 10: {
                        this.lookingFor = 0;
                        break;
                    }
                    default: {
                        assert (false) : "Looking for unexpected char: " + (char)this.lookingFor;
                        {
                            break;
                        }
                    }
                }
            } while (this.lookingFor != 0 && b.hasRemaining());
            if (this.lookingFor == 0) {
                this.currentKey = null;
                this.data = null;
                this.readOffset = 0;
                this.currentFlags = 0;
                this.getLogger().debug("Setting read type back to line.");
                this.setReadType(OperationReadType.LINE);
            }
        }
    }

    @Override
    public final void initialize() {
        int size = 6;
        Collection<byte[]> keyBytes = KeyUtil.getKeyBytes(this.keys);
        for (byte[] k : keyBytes) {
            size += k.length;
            ++size;
        }
        ByteBuffer b = ByteBuffer.allocate(size += this.afterKeyBytesSize());
        b.put(this.cmd.getBytes());
        for (byte[] k : keyBytes) {
            b.put((byte)32);
            b.put(k);
        }
        this.afterKeyBytes(b);
        b.put(RN_BYTES);
        b.flip();
        this.setBuffer(b);
    }

    protected int afterKeyBytesSize() {
        if (this.expBytes == null) {
            return 0;
        }
        return this.expBytes.length + 1;
    }

    protected void afterKeyBytes(ByteBuffer b) {
        if (this.expBytes != null) {
            b.put((byte)32);
            b.put(this.expBytes);
        }
    }

    @Override
    protected final void wasCancelled() {
        this.getCallback().receivedStatus(CANCELLED);
    }

    public String toString() {
        return "Cmd: " + this.cmd + " Keys: " + StringUtils.join(this.keys, " ") + "Exp: " + this.exp;
    }
}

