/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.controls.vlv;

import java.util.Arrays;
import org.apache.directory.api.ldap.extras.controls.vlv.VirtualListViewRequest;
import org.apache.directory.api.ldap.model.message.controls.AbstractControl;
import org.apache.directory.api.util.Strings;

public class VirtualListViewRequestImpl
extends AbstractControl
implements VirtualListViewRequest {
    private int beforeCount;
    private int afterCount;
    private int offset;
    private int contentCount;
    private byte[] contextId;
    private byte[] assertionValue;
    private static final boolean OFFSET_CHOICE = true;
    private boolean targetType = true;
    private static final boolean ASSERTION_VALUE = false;

    public VirtualListViewRequestImpl() {
        super("2.16.840.1.113730.3.4.9");
    }

    @Override
    public int getBeforeCount() {
        return this.beforeCount;
    }

    @Override
    public void setBeforeCount(int beforeCount) {
        this.beforeCount = beforeCount;
    }

    @Override
    public int getAfterCount() {
        return this.afterCount;
    }

    @Override
    public void setAfterCount(int afterCount) {
        this.afterCount = afterCount;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public void setOffset(int offset) {
        this.offset = offset;
        this.targetType = true;
    }

    @Override
    public int getContentCount() {
        return this.contentCount;
    }

    @Override
    public void setContentCount(int contentCount) {
        this.contentCount = contentCount;
    }

    @Override
    public byte[] getAssertionValue() {
        return this.assertionValue;
    }

    @Override
    public void setAssertionValue(byte[] assertionValue) {
        this.assertionValue = assertionValue;
        this.targetType = false;
    }

    @Override
    public byte[] getContextId() {
        return this.contextId;
    }

    @Override
    public void setContextId(byte[] contextId) {
        this.contextId = contextId;
    }

    @Override
    public boolean hasOffset() {
        return this.targetType;
    }

    @Override
    public boolean hasAssertionValue() {
        return !this.targetType;
    }

    public int hashCode() {
        int h = super.hashCode();
        h = h * 37 + this.beforeCount;
        h = h * 37 + this.afterCount;
        h = h * 37 + this.offset;
        h = h * 37 + this.contentCount;
        if (this.contextId != null) {
            for (byte b : this.contextId) {
                h = h * 17 + b;
            }
        }
        return h;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VirtualListViewRequest)) {
            return false;
        }
        VirtualListViewRequest otherControl = (VirtualListViewRequest)o;
        return super.equals(o) && this.beforeCount == otherControl.getBeforeCount() && this.afterCount == otherControl.getAfterCount() && this.offset == otherControl.getOffset() && this.contentCount == otherControl.getContentCount() && Arrays.equals(this.contextId, otherControl.getContextId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    Virtual List View Request Control\n");
        sb.append("        oid : ").append(this.getOid()).append('\n');
        sb.append("        critical : ").append(this.isCritical()).append('\n');
        sb.append("        beforeCount   : '").append(this.beforeCount).append("'\n");
        sb.append("        afterCount   : '").append(this.afterCount).append("'\n");
        sb.append("        target : \n");
        if (this.targetType) {
            sb.append("            offset   : '").append(this.offset).append("'\n");
            sb.append("            contentCount   : '").append(this.contentCount).append("'\n");
        } else {
            sb.append("            assertionValue : '").append(Strings.utf8ToString((byte[])this.assertionValue)).append("'\n");
        }
        if (this.contextId != null) {
            sb.append("        contextID   : '").append(Strings.dumpBytes((byte[])this.contextId)).append("'\n");
        }
        return sb.toString();
    }
}

