/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.ha.dispatch;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.knox.gateway.config.Configure;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.dispatch.ConfigurableDispatch;
import org.apache.knox.gateway.ha.dispatch.i18n.HaDispatchMessages;
import org.apache.knox.gateway.ha.provider.HaProvider;
import org.apache.knox.gateway.ha.provider.HaServiceConfig;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;

public class ConfigurableHADispatch
extends ConfigurableDispatch {
    protected static final String FAILOVER_COUNTER_ATTRIBUTE = "dispatch.ha.failover.counter";
    protected static final HaDispatchMessages LOG = (HaDispatchMessages)MessagesFactory.get(HaDispatchMessages.class);
    private int maxFailoverAttempts = 3;
    private int failoverSleep = 1000;
    private HaProvider haProvider;
    private static final Map<String, String> urlToHashLookup = new HashMap<String, String>();
    private static final Map<String, String> hashToUrlLookup = new HashMap<String, String>();
    private boolean loadBalancingEnabled = false;
    private boolean stickySessionsEnabled = false;
    private boolean noFallbackEnabled = false;
    private String stickySessionCookieName = "KNOX_BACKEND";
    private List<String> disableLoadBalancingForUserAgents = Arrays.asList("ClouderaODBCDriverforApacheHive");
    private AtomicReference<String> activeURL = new AtomicReference();

    public void init() {
        super.init();
        LOG.initializingForResourceRole(this.getServiceRole());
        if (this.haProvider != null) {
            HaServiceConfig serviceConfig = this.haProvider.getHaDescriptor().getServiceConfig(this.getServiceRole());
            this.maxFailoverAttempts = serviceConfig.getMaxFailoverAttempts();
            this.failoverSleep = serviceConfig.getFailoverSleep();
            this.loadBalancingEnabled = serviceConfig.isLoadBalancingEnabled();
            this.stickySessionsEnabled = this.loadBalancingEnabled && serviceConfig.isStickySessionEnabled();
            boolean bl = this.noFallbackEnabled = this.stickySessionsEnabled && serviceConfig.isNoFallbackEnabled();
            if (this.stickySessionsEnabled) {
                this.stickySessionCookieName = serviceConfig.getStickySessionCookieName();
            }
            this.disableLoadBalancingForUserAgents = serviceConfig.getStickySessionDisabledUserAgents();
            this.setupUrlHashLookup();
        }
        this.activeURL.set(this.haProvider.getActiveURL(this.getServiceRole()));
        this.stickySessionCookieName = this.stickySessionCookieName + '-' + this.getServiceRole();
    }

    private void setupUrlHashLookup() {
        for (String url : this.haProvider.getURLs(this.getServiceRole())) {
            String urlHash = this.hash(url);
            urlToHashLookup.put(url, urlHash);
            hashToUrlLookup.put(urlHash, url);
        }
    }

    public HaProvider getHaProvider() {
        return this.haProvider;
    }

    @Configure
    public void setHaProvider(HaProvider haProvider) {
        this.haProvider = haProvider;
    }

    protected void executeRequestWrapper(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse) throws IOException {
        String userAgentFromBrowser = StringUtils.isBlank((CharSequence)inboundRequest.getHeader("User-Agent")) ? "" : inboundRequest.getHeader("User-Agent");
        boolean userAgentDisabled = false;
        if (this.disableLoadBalancingForUserAgents.stream().anyMatch(c -> userAgentFromBrowser.contains((CharSequence)c))) {
            userAgentDisabled = true;
            LOG.disableHALoadbalancinguserAgent(userAgentFromBrowser, this.disableLoadBalancingForUserAgents.toString());
        }
        Optional<Object> backendURI = Optional.empty();
        if (!userAgentDisabled && (backendURI = this.setBackendfromHaCookie(outboundRequest, inboundRequest)).isPresent()) {
            ((HttpRequestBase)outboundRequest).setURI((URI)backendURI.get());
        }
        if (this.loadBalancingEnabled && userAgentDisabled) {
            try {
                ((HttpRequestBase)outboundRequest).setURI(this.updateHostURL(outboundRequest.getURI(), this.activeURL.get()));
            }
            catch (URISyntaxException e) {
                LOG.errorSettingActiveUrl();
            }
        }
        this.executeRequest(outboundRequest, inboundRequest, outboundResponse);
        if (this.loadBalancingEnabled && !userAgentDisabled) {
            if (this.stickySessionsEnabled) {
                if (!backendURI.isPresent()) {
                    this.haProvider.makeNextActiveURLAvailable(this.getServiceRole());
                }
            } else {
                this.haProvider.makeNextActiveURLAvailable(this.getServiceRole());
            }
        }
    }

    protected void outboundResponseWrapper(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse) {
        this.setKnoxHaCookie(outboundRequest, inboundRequest, outboundResponse);
    }

    protected void executeRequest(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse) throws IOException {
        HttpResponse inboundResponse = null;
        try {
            inboundResponse = this.executeOutboundRequest(outboundRequest);
            this.writeOutboundResponse(outboundRequest, inboundRequest, outboundResponse, inboundResponse);
        }
        catch (IOException e) {
            LOG.errorConnectingToServer(outboundRequest.getURI().toString(), e);
            this.failoverRequest(outboundRequest, inboundRequest, outboundResponse, inboundResponse, e);
        }
    }

    private Optional<URI> setBackendfromHaCookie(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest) {
        if (this.loadBalancingEnabled && this.stickySessionsEnabled && inboundRequest.getCookies() != null) {
            for (Cookie cookie : inboundRequest.getCookies()) {
                if (!this.stickySessionCookieName.equals(cookie.getName())) continue;
                String backendURLHash = cookie.getValue();
                String backendURL = hashToUrlLookup.get(backendURLHash);
                if (!this.haProvider.getURLs(this.getServiceRole()).contains(backendURL)) continue;
                try {
                    return Optional.of(this.updateHostURL(outboundRequest.getURI(), backendURL));
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        }
        return Optional.empty();
    }

    private void setKnoxHaCookie(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse) {
        if (this.stickySessionsEnabled) {
            List serviceHaCookies = Collections.emptyList();
            if (inboundRequest.getCookies() != null) {
                serviceHaCookies = Arrays.stream(inboundRequest.getCookies()).filter(cookie -> this.stickySessionCookieName.equals(cookie.getName())).collect(Collectors.toList());
            }
            if (serviceHaCookies != null && !serviceHaCookies.isEmpty() && hashToUrlLookup.containsKey(((Cookie)serviceHaCookies.get(0)).getValue())) {
                return;
            }
            List urls = this.haProvider.getURLs(this.getServiceRole()).stream().filter(u -> u.contains(outboundRequest.getURI().getHost())).collect(Collectors.toList());
            String cookieValue = urlToHashLookup.get(urls.get(0));
            Cookie stickySessionCookie = new Cookie(this.stickySessionCookieName, cookieValue);
            stickySessionCookie.setPath(inboundRequest.getContextPath());
            stickySessionCookie.setMaxAge(-1);
            stickySessionCookie.setHttpOnly(true);
            GatewayConfig config = (GatewayConfig)inboundRequest.getServletContext().getAttribute("org.apache.knox.gateway.config");
            if (config != null) {
                stickySessionCookie.setSecure(config.isSSLEnabled());
            }
            outboundResponse.addCookie(stickySessionCookie);
        }
    }

    protected void failoverRequest(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest, HttpServletResponse outboundResponse, HttpResponse inboundResponse, Exception exception) throws IOException {
        Optional<Object> sessionCookie = Optional.empty();
        if (inboundRequest.getCookies() != null) {
            sessionCookie = Arrays.stream(inboundRequest.getCookies()).findFirst().filter(cookie -> this.stickySessionCookieName.equals(cookie.getName()));
        }
        if (this.stickySessionsEnabled && this.noFallbackEnabled && sessionCookie.isPresent()) {
            LOG.noFallbackError();
            outboundResponse.sendError(502, "Service connection error, HA failover disabled");
            return;
        }
        this.haProvider.markFailedURL(this.getServiceRole(), outboundRequest.getURI().toString());
        AtomicInteger counter = (AtomicInteger)inboundRequest.getAttribute(FAILOVER_COUNTER_ATTRIBUTE);
        if (counter == null) {
            counter = new AtomicInteger(0);
        }
        inboundRequest.setAttribute(FAILOVER_COUNTER_ATTRIBUTE, (Object)counter);
        if (counter.incrementAndGet() <= this.maxFailoverAttempts) {
            this.setupUrlHashLookup();
            inboundRequest.setAttribute("targetRequestUrl", null);
            inboundRequest = new StickySessionCookieRemovedRequest(this.stickySessionCookieName, (HttpServletRequest)inboundRequest);
            URI uri = this.getDispatchUrl((HttpServletRequest)inboundRequest);
            ((HttpRequestBase)outboundRequest).setURI(uri);
            if (this.failoverSleep > 0) {
                try {
                    Thread.sleep(this.failoverSleep);
                }
                catch (InterruptedException e) {
                    LOG.failoverSleepFailed(this.getServiceRole(), e);
                    Thread.currentThread().interrupt();
                }
            }
            LOG.failingOverRequest(outboundRequest.getURI().toString());
            this.activeURL.set(outboundRequest.getURI().toString());
            this.executeRequest(outboundRequest, (HttpServletRequest)inboundRequest, outboundResponse);
        } else {
            LOG.maxFailoverAttemptsReached(this.maxFailoverAttempts, this.getServiceRole());
            if (inboundResponse != null) {
                this.writeOutboundResponse(outboundRequest, (HttpServletRequest)inboundRequest, outboundResponse, inboundResponse);
            } else {
                throw new IOException(exception);
            }
        }
    }

    private String hash(String url) {
        return DigestUtils.sha256Hex((String)url);
    }

    private URI updateHostURL(URI source, String host) throws URISyntaxException {
        URI newUri = new URI(host);
        URIBuilder uriBuilder = new URIBuilder(source);
        uriBuilder.setScheme(newUri.getScheme());
        uriBuilder.setHost(newUri.getHost());
        uriBuilder.setPort(newUri.getPort());
        return uriBuilder.build();
    }

    private static class StickySessionCookieRemovedRequest
    extends HttpServletRequestWrapper {
        private final Cookie[] cookies;

        StickySessionCookieRemovedRequest(String cookieName, HttpServletRequest request) {
            super(request);
            this.cookies = this.filterCookies(cookieName, request.getCookies());
        }

        private Cookie[] filterCookies(String cookieName, Cookie[] cookies) {
            if (super.getCookies() == null) {
                return null;
            }
            ArrayList<Cookie> cookiesInternal = new ArrayList<Cookie>();
            for (Cookie cookie : cookies) {
                if (cookieName.equals(cookie.getName())) continue;
                cookiesInternal.add(cookie);
            }
            return cookiesInternal.toArray(new Cookie[0]);
        }

        public Cookie[] getCookies() {
            return this.cookies;
        }
    }
}

