/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.util;

import java.util.HashMap;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.xml.BasicParserPool;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.config.InitializationService;
import org.opensaml.core.xml.config.XMLObjectProviderRegistry;
import org.pac4j.saml.util.ConfigurationManager;

public class DefaultConfigurationManager
implements ConfigurationManager {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure() {
        Class<ConfigurationService> clazz = ConfigurationService.class;
        synchronized (ConfigurationService.class) {
            XMLObjectProviderRegistry registry = (XMLObjectProviderRegistry)ConfigurationService.get(XMLObjectProviderRegistry.class);
            if (registry == null) {
                registry = new XMLObjectProviderRegistry();
                ConfigurationService.register(XMLObjectProviderRegistry.class, (Object)registry);
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            try {
                InitializationService.initialize();
            }
            catch (InitializationException e) {
                throw new RuntimeException("Exception initializing OpenSAML", e);
            }
            ParserPool parserPool = DefaultConfigurationManager.initParserPool();
            registry.setParserPool(parserPool);
            return;
        }
    }

    private static ParserPool initParserPool() {
        try {
            BasicParserPool parserPool = new BasicParserPool();
            parserPool.setMaxPoolSize(100);
            parserPool.setCoalescing(true);
            parserPool.setIgnoreComments(true);
            parserPool.setNamespaceAware(true);
            parserPool.setExpandEntityReferences(false);
            parserPool.setXincludeAware(false);
            parserPool.setIgnoreElementContentWhitespace(true);
            HashMap builderAttributes = new HashMap();
            parserPool.setBuilderAttributes(builderAttributes);
            HashMap<String, Boolean> features = new HashMap<String, Boolean>();
            features.put("http://apache.org/xml/features/disallow-doctype-decl", Boolean.TRUE);
            features.put("http://apache.org/xml/features/validation/schema/normalized-value", Boolean.FALSE);
            features.put("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
            features.put("http://xml.org/sax/features/external-general-entities", Boolean.FALSE);
            features.put("http://xml.org/sax/features/external-parameter-entities", Boolean.FALSE);
            parserPool.setBuilderFeatures(features);
            parserPool.initialize();
            return parserPool;
        }
        catch (ComponentInitializationException e) {
            throw new RuntimeException("Exception initializing parserPool", e);
        }
    }
}

