/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.descriptor.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.knox.gateway.descriptor.FilterDescriptor;
import org.apache.knox.gateway.descriptor.FilterParamDescriptor;
import org.apache.knox.gateway.descriptor.GatewayDescriptor;
import org.apache.knox.gateway.descriptor.ResourceDescriptor;
import org.apache.knox.gateway.descriptor.ResourceParamDescriptor;
import org.apache.knox.gateway.descriptor.impl.FilterDescriptorImpl;
import org.apache.knox.gateway.descriptor.impl.FilterParamDescriptorImpl;
import org.apache.knox.gateway.descriptor.impl.ResourceParamDescriptorImpl;

public class ResourceDescriptorImpl
implements ResourceDescriptor {
    private GatewayDescriptor parent;
    private String role;
    private String pattern;
    private List<ResourceParamDescriptor> params;
    private List<FilterDescriptor> filters;

    ResourceDescriptorImpl(GatewayDescriptor parent) {
        this.parent = parent;
        this.params = new ArrayList<ResourceParamDescriptor>();
        this.filters = new ArrayList<FilterDescriptor>();
    }

    public GatewayDescriptor up() {
        return this.parent;
    }

    public ResourceDescriptor role(String role) {
        this.role = role;
        return this;
    }

    public String role() {
        return this.role;
    }

    public ResourceDescriptor pattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    public String pattern() {
        return this.pattern;
    }

    public List<FilterDescriptor> filters() {
        return this.filters;
    }

    public FilterDescriptor addFilter() {
        FilterDescriptor filter = this.createFilter();
        this.addFilter(filter);
        return filter;
    }

    public FilterDescriptor createFilter() {
        return new FilterDescriptorImpl(this);
    }

    public void addFilter(FilterDescriptor filter) {
        this.filters.add(filter);
    }

    public void addFilters(List<FilterDescriptor> filters) {
        this.filters.addAll(filters);
    }

    public FilterParamDescriptor createFilterParam() {
        return new FilterParamDescriptorImpl();
    }

    public List<ResourceParamDescriptor> params() {
        return this.params;
    }

    public ResourceParamDescriptor addParam() {
        ResourceParamDescriptor param = this.createParam();
        this.addParam(param);
        return param;
    }

    public ResourceParamDescriptor createParam() {
        return new ResourceParamDescriptorImpl(this);
    }

    public void addParam(ResourceParamDescriptor param) {
        param.up((ResourceDescriptor)this);
        this.params.add(param);
    }

    public void addParams(List<ResourceParamDescriptor> params) {
        if (params != null) {
            for (ResourceParamDescriptor param : params) {
                param.up((ResourceDescriptor)this);
            }
            this.params.addAll(params);
        }
    }
}

