/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.dispatch;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.client.Authenticator;
import org.apache.hadoop.security.authentication.client.KerberosAuthenticator;
import org.apache.knox.gateway.GatewayMessages;
import org.apache.knox.gateway.GatewayResources;
import org.apache.knox.gateway.audit.api.AuditServiceFactory;
import org.apache.knox.gateway.audit.api.Auditor;
import org.apache.knox.gateway.dispatch.DispatchParamResolver;
import org.apache.knox.gateway.filter.AbstractGatewayFilter;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.i18n.resources.ResourcesFactory;
import org.apache.knox.gateway.util.urltemplate.Parser;
import org.apache.knox.gateway.util.urltemplate.Resolver;
import org.apache.knox.gateway.util.urltemplate.Rewriter;
import org.apache.knox.gateway.util.urltemplate.Template;

public class UrlConnectionDispatch
extends AbstractGatewayFilter {
    private static final GatewayMessages LOG = (GatewayMessages)MessagesFactory.get(GatewayMessages.class);
    private static final GatewayResources RES = (GatewayResources)ResourcesFactory.get(GatewayResources.class);
    private static Auditor auditor = AuditServiceFactory.getAuditService().getAuditor("audit", "knox", "knox");

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String method = request.getMethod().toUpperCase(Locale.ROOT);
        if ("GET".equals(method)) {
            try {
                this.doGet(UrlConnectionDispatch.getDispatchUrl(request), request, response);
            }
            catch (URISyntaxException e) {
                throw new ServletException((Throwable)e);
            }
        } else {
            response.sendError(405);
        }
    }

    protected static URI getDispatchUrl(HttpServletRequest request) {
        StringBuffer str = request.getRequestURL();
        String query = request.getQueryString();
        if (query != null) {
            str.append('?');
            str.append(query);
        }
        return URI.create(str.toString());
    }

    public void doGet(URI url, HttpServletRequest request, HttpServletResponse response) throws IOException, URISyntaxException {
        String sourcePathInfo = request.getPathInfo();
        String sourcePattern = this.getConfig().getInitParameter("pattern");
        String targetPattern = this.getConfig().getInitParameter("target");
        Template sourceTemplate = Parser.parseTemplate((String)sourcePattern);
        Template targetTemplate = Parser.parseTemplate((String)targetPattern);
        DispatchParamResolver resolver = new DispatchParamResolver(this.getConfig(), request);
        URI sourceUri = new URI(sourcePathInfo);
        URI targetUri = Rewriter.rewrite((URI)sourceUri, (Template)sourceTemplate, (Template)targetTemplate, (Resolver)resolver, null);
        StringBuilder paramStr = new StringBuilder();
        Enumeration paramNames = request.getParameterNames();
        if (paramNames.hasMoreElements()) {
            paramStr.append('?');
        }
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            String paramValue = request.getParameter(paramName);
            paramStr.append(paramName);
            paramStr.append('=');
            paramStr.append(URLEncoder.encode(paramValue, StandardCharsets.UTF_8.name()));
            if (!paramNames.hasMoreElements()) continue;
            paramStr.append('&');
        }
        String urlStr = targetUri.toString() + paramStr.toString();
        try {
            URL clientUrl = new URL(urlStr);
            AuthenticatedURL.Token token = new AuthenticatedURL.Token();
            KerberosAuthenticator authenticator = new KerberosAuthenticator();
            auditor.audit("dispatch", urlStr, "uri", "unavailable");
            HttpURLConnection conn = new AuthenticatedURL((Authenticator)authenticator).openConnection(clientUrl, token);
            InputStream input = conn.getInputStream();
            if (input != null) {
                try (ServletOutputStream output = response.getOutputStream();){
                    IOUtils.copy((InputStream)input, (OutputStream)output);
                }
            }
            auditor.audit("dispatch", urlStr, "uri", "success");
        }
        catch (AuthenticationException e) {
            response.sendError(401);
            LOG.failedToEstablishConnectionToUrl(urlStr, (Exception)((Object)e));
            auditor.audit("dispatch", urlStr, "uri", "failure", RES.responseStatus(401));
        }
        catch (FileNotFoundException e) {
            response.sendError(404);
            LOG.failedToEstablishConnectionToUrl(urlStr, e);
            auditor.audit("dispatch", urlStr, "uri", "failure", RES.responseStatus(404));
        }
    }
}

