/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.request.modify;

import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.ModifyRequestDecorator;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreModifyRequestAttributeValue
extends GrammarAction<LdapMessageContainer<ModifyRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreModifyRequestAttributeValue.class);

    public StoreModifyRequestAttributeValue() {
        super("Stores AttributeValue");
    }

    public void action(LdapMessageContainer<ModifyRequestDecorator> container) {
        ModifyRequestDecorator modifyRequestDecorator = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        byte[] value = Strings.EMPTY_BYTES;
        try {
            if (tlv.getLength() == 0) {
                modifyRequestDecorator.addAttributeValue("");
            } else {
                value = tlv.getValue().getData();
                if (container.isBinary(modifyRequestDecorator.getCurrentAttributeType())) {
                    modifyRequestDecorator.addAttributeValue(value);
                } else {
                    modifyRequestDecorator.addAttributeValue(Strings.utf8ToString((byte[])value));
                }
            }
        }
        catch (LdapException ldapException) {
            // empty catch block
        }
        container.setGrammarEndAllowed(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_05131_VALUE_MODIFIED, (Object[])new Object[]{value}));
        }
    }
}

