/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.extras.controls.ad_impl;

import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.Asn1Object;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.Asn1Container;
import org.apache.directory.api.asn1.ber.Asn1Decoder;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.ControlDecorator;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.extras.controls.ad.AdPolicyHints;
import org.apache.directory.api.ldap.extras.controls.ad.AdPolicyHintsImpl;
import org.apache.directory.api.ldap.extras.controls.ad_impl.AdPolicyHintsContainer;
import org.apache.directory.api.ldap.model.message.Control;

public class AdPolicyHintsDecorator
extends ControlDecorator<AdPolicyHints>
implements AdPolicyHints {
    private int seqLength;
    private static final Asn1Decoder DECODER = new Asn1Decoder();

    public AdPolicyHintsDecorator(LdapApiService codec) {
        this(codec, (AdPolicyHints)new AdPolicyHintsImpl());
    }

    public AdPolicyHintsDecorator(LdapApiService codec, AdPolicyHints adPolicyHintsRequest) {
        super(codec, (Control)adPolicyHintsRequest);
    }

    public int computeLength() {
        this.seqLength = 2 + BerValue.getNbBytes((int)this.getFlags());
        this.valueLength = 1 + TLV.getNbBytes((int)this.seqLength) + this.seqLength;
        return this.valueLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err((I18n)I18n.ERR_08000_CANNOT_PUT_A_PDU_IN_NULL_BUFFER, (Object[])new Object[0]));
        }
        buffer.put(UniversalTag.SEQUENCE.getValue());
        buffer.put(TLV.getBytes((int)this.seqLength));
        BerValue.encode((ByteBuffer)buffer, (int)this.getFlags());
        return buffer;
    }

    public byte[] getValue() {
        if (this.value == null) {
            try {
                this.computeLength();
                ByteBuffer buffer = ByteBuffer.allocate(this.valueLength);
                this.value = this.encode(buffer).array();
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.value;
    }

    public Asn1Object decode(byte[] controlBytes) throws DecoderException {
        ByteBuffer buffer = ByteBuffer.wrap(controlBytes);
        AdPolicyHintsContainer container = new AdPolicyHintsContainer(this, this.getCodecService());
        DECODER.decode(buffer, (Asn1Container)container);
        return this;
    }

    public int getFlags() {
        return ((AdPolicyHints)this.getDecorated()).getFlags();
    }

    public void setFlags(int flags) {
        ((AdPolicyHints)this.getDecorated()).setFlags(flags);
    }
}

