/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.service;

import java.util.Hashtable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionListener;
import org.apache.felix.http.api.ExtHttpService;
import org.apache.felix.http.base.internal.registry.HandlerRegistry;
import org.apache.felix.http.base.internal.service.PerBundleHttpServiceImpl;
import org.apache.felix.http.base.internal.service.SharedHttpServiceImpl;
import org.apache.felix.http.base.internal.service.listener.HttpSessionAttributeListenerManager;
import org.apache.felix.http.base.internal.service.listener.HttpSessionListenerManager;
import org.apache.felix.http.base.internal.service.listener.ServletContextAttributeListenerManager;
import org.apache.felix.http.base.internal.service.listener.ServletRequestAttributeListenerManager;
import org.apache.felix.http.base.internal.service.listener.ServletRequestListenerManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpService;

public final class HttpServiceFactory
implements ServiceFactory<HttpService> {
    public static final String HTTP_SERVICE_CONTEXT_NAME = "org.osgi.service.http";
    public static final long HTTP_SERVICE_CONTEXT_SERVICE_ID = -1L;
    private static final String FELIX_HTTP_SHARED_SERVLET_CONTEXT_ATTRIBUTES = "org.apache.felix.http.shared_servlet_context_attributes";
    private static final String OBSOLETE_REG_PROPERTY_ENDPOINTS = "osgi.http.service.endpoints";
    private final BundleContext bundleContext;
    private final boolean sharedContextAttributes;
    private final ServletContextAttributeListenerManager contextAttributeListenerManager;
    private final ServletRequestListenerManager requestListenerManager;
    private final ServletRequestAttributeListenerManager requestAttributeListenerManager;
    private final HttpSessionListenerManager sessionListenerManager;
    private final HttpSessionAttributeListenerManager sessionAttributeListenerManager;
    private final Hashtable<String, Object> httpServiceProps = new Hashtable();
    private volatile ServletContext context;
    private volatile ServiceRegistration<?> httpServiceReg;
    private final HandlerRegistry handlerRegistry;
    private volatile SharedHttpServiceImpl sharedHttpService;

    public HttpServiceFactory(BundleContext bundleContext, HandlerRegistry handlerRegistry) {
        this.bundleContext = bundleContext;
        this.handlerRegistry = handlerRegistry;
        this.sharedContextAttributes = this.getBoolean(FELIX_HTTP_SHARED_SERVLET_CONTEXT_ATTRIBUTES);
        this.contextAttributeListenerManager = new ServletContextAttributeListenerManager(bundleContext);
        this.requestListenerManager = new ServletRequestListenerManager(bundleContext);
        this.requestAttributeListenerManager = new ServletRequestAttributeListenerManager(bundleContext);
        this.sessionListenerManager = new HttpSessionListenerManager(bundleContext);
        this.sessionAttributeListenerManager = new HttpSessionAttributeListenerManager(bundleContext);
    }

    public void start(ServletContext context) {
        this.context = context;
        this.contextAttributeListenerManager.open();
        this.requestListenerManager.open();
        this.requestAttributeListenerManager.open();
        this.sessionListenerManager.open();
        this.sessionAttributeListenerManager.open();
        this.sharedHttpService = new SharedHttpServiceImpl(this.handlerRegistry);
        String[] ifaces = new String[]{HttpService.class.getName(), ExtHttpService.class.getName()};
        this.httpServiceReg = this.bundleContext.registerService(ifaces, (Object)this, this.httpServiceProps);
    }

    public void stop() {
        this.context = null;
        if (this.httpServiceReg != null) {
            this.httpServiceReg.unregister();
            this.httpServiceReg = null;
        }
        this.sharedHttpService = null;
        this.contextAttributeListenerManager.close();
        this.requestListenerManager.close();
        this.requestAttributeListenerManager.close();
        this.sessionListenerManager.close();
        this.sessionAttributeListenerManager.close();
    }

    public HttpService getService(Bundle bundle, ServiceRegistration<HttpService> reg) {
        return new PerBundleHttpServiceImpl(bundle, this.sharedHttpService, this.context, this.contextAttributeListenerManager, this.sharedContextAttributes, this.requestListenerManager, this.requestAttributeListenerManager);
    }

    public void ungetService(Bundle bundle, ServiceRegistration<HttpService> reg, HttpService service) {
        if (service instanceof PerBundleHttpServiceImpl) {
            ((PerBundleHttpServiceImpl)service).unregisterAll();
        }
    }

    public ServletContextAttributeListenerManager getContextAttributeListener() {
        return this.contextAttributeListenerManager;
    }

    public HttpSessionListener getSessionListener() {
        return this.sessionListenerManager;
    }

    public HttpSessionAttributeListener getSessionAttributeListener() {
        return this.sessionAttributeListenerManager;
    }

    public long getHttpServiceServiceId() {
        return (Long)this.httpServiceReg.getReference().getProperty("service.id");
    }

    public void setProperties(Hashtable<String, Object> props) {
        this.httpServiceProps.clear();
        this.httpServiceProps.putAll(props);
        if (this.httpServiceProps.get("osgi.http.endpoint") != null) {
            this.httpServiceProps.put(OBSOLETE_REG_PROPERTY_ENDPOINTS, this.httpServiceProps.get("osgi.http.endpoint"));
        }
        if (this.httpServiceReg != null) {
            this.httpServiceReg.setProperties(this.httpServiceProps);
        }
    }

    private boolean getBoolean(String property) {
        String prop = this.bundleContext.getProperty(property);
        return prop != null ? Boolean.valueOf(prop) : false;
    }
}

