/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wiki.InternalWikiException;
import org.apache.wiki.api.core.Engine;
import org.apache.wiki.event.WikiEngineEvent;
import org.apache.wiki.event.WikiEvent;
import org.apache.wiki.event.WikiEventListener;

public abstract class WikiBackgroundThread
extends Thread
implements WikiEventListener {
    private static final Logger LOG = LogManager.getLogger(WikiBackgroundThread.class);
    private volatile boolean m_killMe;
    private final Engine m_engine;
    private final int m_interval;
    private static final long POLLING_INTERVAL = 1000L;

    public WikiBackgroundThread(Engine engine, int sleepInterval) {
        this.m_engine = engine;
        this.m_interval = sleepInterval;
        engine.addWikiEventListener((WikiEventListener)this);
        this.setDaemon(false);
    }

    public final void actionPerformed(WikiEvent event) {
        if (event instanceof WikiEngineEvent && event.getType() == 1) {
            LOG.warn("Detected wiki engine shutdown: killing " + this.getName() + ".");
            this.m_killMe = true;
        }
    }

    public abstract void backgroundTask() throws Exception;

    public Engine getEngine() {
        return this.m_engine;
    }

    public void shutdown() {
        this.m_killMe = true;
    }

    @Override
    public final void run() {
        try {
            String name = this.getName();
            LOG.warn("Starting up background thread: " + name + ".");
            this.startupTask();
            while (!this.m_killMe) {
                this.backgroundTask();
                boolean interrupted = false;
                try {
                    for (int i = 0; i < this.m_interval; ++i) {
                        Thread.sleep(1000L);
                        if (!this.m_killMe) continue;
                        interrupted = true;
                        LOG.warn("Interrupted background thread: " + name + ".");
                        break;
                    }
                    if (!interrupted) continue;
                    break;
                }
                catch (Throwable t) {
                    LOG.error("Background thread error: (stack trace follows)", t);
                }
            }
            this.shutdownTask();
        }
        catch (Throwable t) {
            LOG.error("Background thread error: (stack trace follows)", t);
            throw new InternalWikiException(t.getMessage(), t);
        }
    }

    public void shutdownTask() throws Exception {
    }

    public void startupTask() throws Exception {
    }
}

