/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testbeans.gui;

import java.beans.PropertyEditorSupport;

public class BooleanPropertyEditor
extends PropertyEditorSupport {
    private static final String FALSE = "False";
    private static final String TRUE = "True";
    private static final String[] TAGS = new String[]{"True", "False"};

    @Override
    public String getAsText() {
        Object value = this.getValue();
        return value instanceof Boolean ? BooleanPropertyEditor.toString((Boolean)value) : null;
    }

    private static String toString(Boolean value) {
        return value != false ? TRUE : FALSE;
    }

    @Override
    public void setAsText(String text) {
        this.setValue(text);
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof String) {
            super.setValue(Boolean.valueOf((String)value));
        } else if (value == null || value instanceof Boolean) {
            super.setValue(value);
        } else {
            throw new IllegalArgumentException("Unexpected type: " + value.getClass().getName());
        }
    }

    @Override
    public String[] getTags() {
        return TAGS;
    }
}

