/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.jms.sampler.render;

import com.github.benmanes.caffeine.cache.Cache;
import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.jmeter.protocol.jms.sampler.render.MessageRenderer;
import org.apache.jmeter.protocol.jms.sampler.render.TextMessageRenderer;
import org.apache.jmeter.util.JMeterUtils;

class ObjectMessageRenderer
implements MessageRenderer<Serializable> {
    TextMessageRenderer delegate;

    public ObjectMessageRenderer(TextMessageRenderer delegate) {
        this.delegate = delegate;
    }

    @Override
    public Serializable getValueFromFile(String filename, String encoding, boolean hasVariable, Cache<Object, Object> cache) {
        Serializable value = hasVariable ? this.getInterpretedContent(filename, encoding, hasVariable, cache) : (Serializable)cache.get((Object)filename, p -> this.getContent(filename));
        return value;
    }

    @Override
    public Serializable getValueFromText(String xmlMessage) {
        Serializable readObject = null;
        try {
            XStream xstream = JMeterUtils.createXStream();
            readObject = (Serializable)xstream.fromXML(xmlMessage, readObject);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to load object instance from text", e);
        }
        return readObject;
    }

    protected Serializable getInterpretedContent(String filename, String pEncoding, boolean hasVariable, Cache<Object, Object> cache) {
        String encoding = pEncoding;
        if ("<DEFAULT>".equals(encoding)) {
            encoding = this.findEncoding(filename);
        }
        Object stringValue = this.delegate.getValueFromFile(filename, encoding, hasVariable, (Cache)cache);
        return (Serializable)JMeterUtils.createXStream().fromXML((String)stringValue);
    }

    protected String findEncoding(String filename) {
        String string;
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        FileInputStream input = new FileInputStream(filename);
        try {
            XMLStreamReader reader = factory.createXMLStreamReader(input);
            string = reader.getEncoding();
        }
        catch (Throwable throwable) {
            try {
                try {
                    input.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | XMLStreamException e) {
                throw new IllegalArgumentException(String.format("Unable to read %s", filename), e);
            }
        }
        input.close();
        return string;
    }

    protected Serializable getContent(String filename) {
        return (Serializable)JMeterUtils.createXStream().fromXML(new File(filename));
    }
}

