/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.util.pngj;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.util.pngj.ArrayUtilsKt;
import org.jetbrains.letsPlot.util.pngj.OutputPngStream;
import org.jetbrains.letsPlot.util.pngj.PngjOutputException;
import org.jetbrains.letsPlot.util.pngj.chunks.ChunkHelper;
import org.jetbrains.letsPlot.util.pngj.chunks.ChunkRaw;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\n\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0000\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0017\u001a\u00020\u0018J\b\u0010\u0019\u001a\u00020\u0018H\u0002J\u000e\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0005J\b\u0010\u001c\u001a\u00020\u0005H\u0002J\b\u0010\u001d\u001a\u00020\u0018H\u0002J\u001e\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0005R\u001e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/IdatChunkWriter;", "", "outputStream", "Lorg/jetbrains/letsPlot/util/pngj/OutputPngStream;", "maxChunkLength", "", "(Lorg/jetbrains/letsPlot/util/pngj/OutputPngStream;I)V", "<set-?>", "availLen", "getAvailLen", "()I", "", "buf", "getBuf", "()[B", "chunkId", "getChunkId", "chunksWriten", "maxChunkLen", "offset", "getOffset", "totalBytesWriten", "", "close", "", "flush", "incrementOffset", "n", "minLenToWrite", "postReset", "write", "b", "o", "len", "Companion", "plot-api"})
public final class IdatChunkWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OutputPngStream outputStream;
    private final int maxChunkLen;
    @NotNull
    private byte[] buf;
    private int offset;
    private int availLen;
    private long totalBytesWriten;
    private int chunksWriten;
    private static final int MAX_LEN_DEFAULT = 32768;

    @JvmOverloads
    public IdatChunkWriter(@NotNull OutputPngStream outputStream, int maxChunkLength) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        this.outputStream = outputStream;
        this.maxChunkLen = maxChunkLength > 0 ? maxChunkLength : 32768;
        this.buf = new byte[this.maxChunkLen];
        this.availLen = this.maxChunkLen - this.offset;
        this.postReset();
    }

    public /* synthetic */ IdatChunkWriter(OutputPngStream outputPngStream, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        this(outputPngStream, n);
    }

    @NotNull
    public final byte[] getBuf() {
        return this.buf;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final int getAvailLen() {
        return this.availLen;
    }

    private final byte[] getChunkId() {
        return ChunkHelper.INSTANCE.getB_IDAT();
    }

    private final void flush() {
        if (this.offset > 0 && this.offset >= this.minLenToWrite()) {
            ChunkRaw c = new ChunkRaw(this.offset, this.getChunkId(), false);
            c.setData(this.buf);
            c.writeChunk(this.outputStream);
            this.totalBytesWriten += (long)(c.getLen() + 12);
            int n = this.chunksWriten;
            this.chunksWriten = n + 1;
            this.offset = 0;
            this.availLen = this.maxChunkLen;
            this.postReset();
        }
    }

    public final void incrementOffset(int n) {
        this.offset += n;
        this.availLen -= n;
        if (this.availLen < 0) {
            throw new PngjOutputException("Anomalous situation");
        }
        if (this.availLen == 0) {
            this.flush();
        }
    }

    public final void write(@NotNull byte[] b, int o, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int o2 = o;
        int len2 = len;
        while (len2 > 0) {
            int n = len2 <= this.availLen ? len2 : this.availLen;
            ArrayUtilsKt.arraycopy(b, o2, this.buf, this.offset, n);
            this.incrementOffset(n);
            len2 -= n;
            o2 += n;
        }
    }

    private final void postReset() {
    }

    private final int minLenToWrite() {
        return 1;
    }

    public final void close() {
        this.flush();
        this.offset = 0;
    }

    @JvmOverloads
    public IdatChunkWriter(@NotNull OutputPngStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        this(outputStream, 0, 2, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/IdatChunkWriter$Companion;", "", "()V", "MAX_LEN_DEFAULT", "", "plot-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

