/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.icons;

import com.github.weisj.darklaf.icons.AwareIconStyle;
import com.github.weisj.darklaf.icons.IconLoader;
import com.github.weisj.darklaf.icons.UIAwareIcon;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public abstract class DefaultUIAwareIcon
implements UIAwareIcon {
    private final UIAwareIcon dual;
    protected Icon light;
    protected Icon dark;

    public DefaultUIAwareIcon() {
        this.dual = this.createDual();
    }

    protected abstract UIAwareIcon createDual();

    protected DefaultUIAwareIcon(DefaultUIAwareIcon dual) {
        this.dark = dual.light;
        this.light = dual.dark;
        this.dual = dual;
    }

    @Override
    public UIAwareIcon getDual() {
        return this.dual;
    }

    private boolean isDark() {
        return IconLoader.getAwareStyle() == AwareIconStyle.DARK;
    }

    private Icon getEffectiveIcon() {
        return this.isDark() ? this.getDarkIcon() : this.getLightIcon();
    }

    protected abstract Icon loadLightIcon();

    protected abstract Icon loadDarkIcon();

    private Icon getLightIcon() {
        if (this.light == null) {
            this.light = this.loadLightIcon();
        }
        return this.light;
    }

    private Icon getDarkIcon() {
        if (this.dark == null) {
            this.dark = this.loadDarkIcon();
        }
        return this.dark;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.getEffectiveIcon().paintIcon(c, g, x, y);
    }

    @Override
    public int getIconWidth() {
        return this.getEffectiveIcon().getIconWidth();
    }

    @Override
    public int getIconHeight() {
        return this.getEffectiveIcon().getIconHeight();
    }
}

