/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions;

import java.io.Serializable;
import java.text.MessageFormat;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractScopedAssertion;
import org.apache.jmeter.util.JMeterUtils;

public class DurationAssertion
extends AbstractScopedAssertion
implements Serializable,
Assertion {
    private static final long serialVersionUID = 241L;
    public static final String DURATION_KEY = "DurationAssertion.duration";

    public AssertionResult getResult(SampleResult response) {
        long responseTime;
        AssertionResult result = new AssertionResult(this.getName());
        result.setFailure(false);
        long duration = this.getAllowedDuration();
        if (duration > 0L && (responseTime = response.getTime()) > duration) {
            result.setFailure(true);
            Object[] arguments = new Object[]{responseTime, duration};
            String message = MessageFormat.format(JMeterUtils.getResString((String)"duration_assertion_failure"), arguments);
            result.setFailureMessage(message);
        }
        return result;
    }

    private long getAllowedDuration() {
        return this.getPropertyAsLong(DURATION_KEY);
    }

    public void setAllowedDuration(long duration) {
        this.setProperty(DURATION_KEY, duration);
    }
}

