/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.table.renderer;

import com.github.weisj.darklaf.ui.combobox.DarkComboBoxUI;
import com.github.weisj.darklaf.ui.table.TextTableCellEditorBorder;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.DefaultFormatter;

public class DarkTableCellEditor
extends DefaultCellEditor {
    private static final JCheckBox dummyCheckBox = new JCheckBox();

    public DarkTableCellEditor() {
        this(new JTextField());
    }

    public DarkTableCellEditor(JTextField textField) {
        super(textField);
        textField.setBorder(new TextTableCellEditorBorder());
        textField.putClientProperty("JComponent.isTableEditor", true);
        this.setClickCountToStart(2);
    }

    public DarkTableCellEditor(final JComboBox<Object> comboBox) {
        super(comboBox);
        final DefaultCellEditor.EditorDelegate del = this.delegate;
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            @Override
            public void setValue(Object value) {
                comboBox.removeAllItems();
                if (value != null && value.getClass().isArray()) {
                    for (Object obj : (Object[])value) {
                        comboBox.addItem(obj);
                    }
                } else {
                    comboBox.addItem(value);
                    comboBox.setSelectedItem(value);
                }
            }

            @Override
            public Object getCellEditorValue() {
                return del.getCellEditorValue();
            }

            @Override
            public boolean shouldSelectCell(EventObject anEvent) {
                return del.shouldSelectCell(anEvent);
            }

            @Override
            public boolean stopCellEditing() {
                return del.stopCellEditing();
            }
        };
        comboBox.putClientProperty("JComponent.isTableEditor", true);
        this.setClickCountToStart(2);
    }

    public DarkTableCellEditor(final JSpinner spinner) {
        super(dummyCheckBox);
        this.editorComponent = spinner;
        spinner.putClientProperty("JComponent.isTableEditor", Boolean.TRUE);
        this.setClickCountToStart(2);
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            @Override
            public Object getCellEditorValue() {
                return spinner.getValue();
            }

            @Override
            public void setValue(Object value) {
                try {
                    JSpinner.DefaultEditor defaultEditor;
                    JFormattedTextField.AbstractFormatter formatter;
                    JComponent editor;
                    SpinnerModel model = spinner.getModel();
                    if (model instanceof SpinnerNumberModel && !(value instanceof Number)) {
                        spinner.setValue(NumberFormat.getInstance().parse(value.toString()));
                    } else if (model instanceof SpinnerDateModel && !(value instanceof Date)) {
                        spinner.setValue(DateFormat.getInstance().parse(value.toString()));
                    } else {
                        spinner.setValue(value);
                    }
                    if (spinner.getValue() != null && (editor = spinner.getEditor()) instanceof JSpinner.DefaultEditor && (formatter = (defaultEditor = (JSpinner.DefaultEditor)editor).getTextField().getFormatter()) instanceof DefaultFormatter) {
                        ((DefaultFormatter)formatter).setValueClass(spinner.getValue().getClass());
                    }
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }

            @Override
            public boolean shouldSelectCell(EventObject anEvent) {
                if (anEvent instanceof MouseEvent) {
                    MouseEvent e = (MouseEvent)anEvent;
                    return e.getID() != 506;
                }
                return true;
            }
        };
        this.setClickCountToStart(2);
    }

    public DarkTableCellEditor(JCheckBox checkBox) {
        this((JToggleButton)checkBox);
    }

    public DarkTableCellEditor(final JToggleButton toggleButton) {
        super(dummyCheckBox);
        this.editorComponent = toggleButton;
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            @Override
            public Object getCellEditorValue() {
                return toggleButton.isSelected();
            }

            @Override
            public void setValue(Object value) {
                boolean selected = false;
                if (value instanceof Boolean) {
                    selected = (Boolean)value;
                } else if (value instanceof String) {
                    selected = value.equals("true");
                }
                toggleButton.setSelected(selected);
            }
        };
        toggleButton.putClientProperty("JComponent.isTableEditor", true);
        toggleButton.addActionListener(this.delegate);
        toggleButton.setRequestFocusEnabled(false);
    }

    @Override
    public boolean stopCellEditing() {
        if (this.editorComponent instanceof JComboBox) {
            ((DarkComboBoxUI)((JComboBox)this.editorComponent).getUI()).resetPopup();
        }
        return super.stopCellEditing();
    }
}

