/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.task;

import com.github.weisj.darklaf.DarkLaf;
import com.github.weisj.darklaf.PropertyLoader;
import com.github.weisj.darklaf.task.DefaultsInitTask;
import com.github.weisj.darklaf.theme.Theme;
import com.github.weisj.darklaf.theme.info.FontSizeRule;
import com.github.weisj.darklaf.uiresource.DarkFontUIResource;
import com.github.weisj.darklaf.util.FontUtil;
import com.github.weisj.darklaf.util.LogUtil;
import com.github.weisj.darklaf.util.PropertyUtil;
import com.github.weisj.darklaf.util.SystemInfo;
import java.awt.DisplayMode;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Logger;
import javax.swing.UIDefaults;
import javax.swing.plaf.UIResource;

public class FontDefaultsInitTask
implements DefaultsInitTask {
    private static final Logger LOGGER = LogUtil.getLogger(FontDefaultsInitTask.class);
    private static final String SWING_AA_KEY = "swing.aatext";
    private static final String SWING_AA_DEFAULT_VALUE = "true";
    private static final String FONT_PROPERTY_PATH = "properties/";
    private static final String FONT_SIZE_DEFAULTS_NAME = "font_sizes";
    private static final String FONT_DEFAULTS_NAME = "font";
    private static final String KERNING_ALLOW_LIST = "kerning.allowList";
    private static final String KERNING_BLOCK_LIST = "kerning.blockList";
    private static final int LCD_TEXT_ANTIALIASING_MIN_BIT_DEPTH = 15;
    private static final String ALL_FONTS = "__all__";
    private static final Map<AttributedCharacterIterator.Attribute, Integer> ENABLE_KERNING = Collections.singletonMap(TextAttribute.KERNING, TextAttribute.KERNING_ON);
    private static final Map<AttributedCharacterIterator.Attribute, Integer> DISABLE_KERNING = Collections.singletonMap(TextAttribute.KERNING, null);
    private static final String MAC_OS_CATALINA_FONT_NAME = ".AppleSystemUIFont";
    private static final String MAC_OS_CATALINA_FONT_NAME_FALLBACK = "Helvetica Neue";
    private static final String MAC_OS_FONT_NAME = ".SF NS Text";
    private static final String WINDOWS_10_FONT_NAME = "Segoe UI";
    private static final String WINDOWS_10_MONO_FONT_NAME = "Consolas";

    @Override
    public void run(Theme currentTheme, UIDefaults defaults) {
        this.loadFontProperties(defaults);
        if (SystemInfo.isMac) {
            this.patchOSFonts(defaults, this::mapMacOSFont);
        } else if (SystemInfo.isWindows) {
            this.patchOSFonts(defaults, this::mapWindowsFont);
        }
        if (SystemInfo.isMacOSCatalina) {
            defaults.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        }
        if (this.systemKerningEnabled()) {
            List allowedFonts = PropertyUtil.getList((UIDefaults)defaults, (String)KERNING_ALLOW_LIST, String.class);
            List blockedFonts = PropertyUtil.getList((UIDefaults)defaults, (String)KERNING_BLOCK_LIST, String.class);
            if (!allowedFonts.isEmpty()) {
                HashSet allowedFontsSet = new HashSet(allowedFonts);
                HashSet blockedFontSet = new HashSet(blockedFonts);
                boolean enabledAll = ALL_FONTS.equals(allowedFonts.get(0));
                this.setupKerningPerFont(defaults, key -> (enabledAll || allowedFontsSet.contains(key)) && !blockedFontSet.contains(key));
            }
        }
        this.applyFontRule(currentTheme, defaults);
        this.setupRenderingHints(defaults);
        defaults.remove(KERNING_ALLOW_LIST);
        defaults.remove(KERNING_BLOCK_LIST);
    }

    private boolean systemKerningEnabled() {
        if (SystemInfo.isMac) {
            return SystemInfo.isMacOSMojave;
        }
        if (SystemInfo.isWindows) {
            return SystemInfo.isWindowsVista;
        }
        return false;
    }

    private void setupRenderingHints(UIDefaults defaults) {
        if (!SystemInfo.isMacOSMojave) {
            PropertyUtil.installSystemProperty((String)SWING_AA_KEY, (String)SWING_AA_DEFAULT_VALUE);
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Map desktopHints = (Map)toolkit.getDesktopProperty("awt.font.desktophints");
            if (desktopHints == null) {
                desktopHints = Collections.emptyMap();
            }
            Object aaHint = desktopHints.get(RenderingHints.KEY_TEXT_ANTIALIASING);
            Object lcdContrastHint = desktopHints.get(RenderingHints.KEY_TEXT_LCD_CONTRAST);
            if (!GraphicsEnvironment.isHeadless() && aaHint == null) {
                GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
                DisplayMode displayMode = device.getDisplayMode();
                int bitDepth = displayMode.getBitDepth();
                boolean appropriateBitDepth = bitDepth >= 15 || bitDepth == -1;
                boolean appropriateDisplayMode = device.getType() != 1;
                aaHint = appropriateBitDepth && appropriateDisplayMode ? RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB : RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
                String message = "System property 'awt.useSystemAAFontSettings' is not set. Using '" + aaHint + "'\nIt's recommended to manually add the property to the JVM startup parameters on your platform for optimal text antialiasing. Refer to the [documentation](https://docs.oracle.com/javase/8/docs/technotes/guides/2d/flags.html#aaFonts)for more information on the possible values.";
                if (!SystemInfo.isJava9OrGreater) {
                    message = message + "\n";
                    message = message + "If you are using a Java version of 8 or earlier try switching to at least Java 9 for improved scaling and font rendering support.";
                }
                LOGGER.warning(message);
            }
            if (aaHint != null) {
                LOGGER.fine(String.format("Setting '%s' = '%s'", RenderingHints.KEY_TEXT_ANTIALIASING, aaHint));
                defaults.put(RenderingHints.KEY_TEXT_ANTIALIASING, aaHint);
            }
            if (lcdContrastHint != null) {
                LOGGER.fine(String.format("Setting '%s' = '%s'", RenderingHints.KEY_TEXT_LCD_CONTRAST, lcdContrastHint));
                defaults.put(RenderingHints.KEY_TEXT_LCD_CONTRAST, lcdContrastHint);
            }
        }
    }

    private void loadFontProperties(UIDefaults defaults) {
        Properties fontSizeProps = PropertyLoader.loadProperties(DarkLaf.class, (String)FONT_SIZE_DEFAULTS_NAME, (String)FONT_PROPERTY_PATH);
        PropertyLoader.putProperties((Properties)fontSizeProps, (UIDefaults)defaults);
        Properties fontProps = PropertyLoader.loadProperties(DarkLaf.class, (String)FONT_DEFAULTS_NAME, (String)FONT_PROPERTY_PATH);
        PropertyLoader.putProperties((Properties)fontProps, (UIDefaults)defaults);
    }

    private void patchOSFonts(UIDefaults defaults, Function<Map.Entry<Object, Font>, Font> mapper) {
        PropertyLoader.replacePropertyEntriesOfType(Font.class, (Map)defaults, e -> this.isDefaultFont((Font)e.getValue()) || this.isMonospaceDefault((Font)e.getValue()), mapper);
    }

    private boolean isDefaultFont(Font font) {
        return "Dialog".equals(font.getFamily());
    }

    private boolean isMonospaceDefault(Font font) {
        return "Monospaced".equals(font.getFamily());
    }

    private Font mapMacOSFont(Map.Entry<Object, Font> entry) {
        Font font = entry.getValue();
        if (this.isMonospaceDefault(font)) {
            return font;
        }
        String fontName = SystemInfo.isMacOSCatalina ? MAC_OS_CATALINA_FONT_NAME_FALLBACK : MAC_OS_FONT_NAME;
        Font macFont = FontUtil.createFont((String)fontName, (int)font.getStyle(), (int)font.getSize());
        if (SystemInfo.isMacOSMojave) {
            macFont = macFont.deriveFont(ENABLE_KERNING);
        }
        if (font instanceof UIResource) {
            macFont = new DarkFontUIResource(macFont);
        }
        return macFont == null ? font : macFont;
    }

    private Font mapWindowsFont(Map.Entry<Object, Font> entry) {
        Font font = entry.getValue();
        if (!SystemInfo.isWindowsVista) {
            return font;
        }
        String fontName = this.isMonospaceDefault(font) ? WINDOWS_10_MONO_FONT_NAME : WINDOWS_10_FONT_NAME;
        Font windowsFont = FontUtil.createFont((String)fontName, (int)font.getStyle(), (int)font.getSize());
        if (font instanceof UIResource) {
            windowsFont = new DarkFontUIResource(windowsFont);
        }
        return windowsFont;
    }

    private void setupKerningPerFont(UIDefaults defaults, Predicate<String> kerningPredicate) {
        PropertyLoader.replacePropertiesOfType(Font.class, (Map)defaults, e -> kerningPredicate.test(e.getKey().toString()), f -> {
            Font font = f.deriveFont(ENABLE_KERNING);
            if (f instanceof UIResource) {
                font = new DarkFontUIResource(font);
            }
            return font;
        });
    }

    private void applyFontRule(Theme currentTheme, UIDefaults defaults) {
        FontSizeRule rule = currentTheme.getFontSizeRule();
        if (rule == null || rule.getType() == FontSizeRule.AdjustmentType.NO_ADJUSTMENT) {
            return;
        }
        PropertyLoader.replacePropertiesOfType(Font.class, (Map)defaults, f -> this.fontWithRule((Font)f, rule));
    }

    private Font fontWithRule(Font font, FontSizeRule rule) {
        if (font == null) {
            return null;
        }
        float size = font.getSize2D();
        float newSize = rule.adjustFontSize(size);
        if (newSize == size) {
            return font;
        }
        if (newSize <= 0.0f) {
            LOGGER.warning("Font " + font + " would be invisible after applying " + rule + ". Font won't be changed!");
            return font;
        }
        Font withRule = font.deriveFont(newSize);
        if (font instanceof UIResource && !(withRule instanceof UIResource)) {
            withRule = new DarkFontUIResource(withRule);
        }
        return withRule;
    }
}

