/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.queue.jms;

import java.io.IOException;
import java.io.InputStream;
import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import javax.mail.util.SharedByteArrayInputStream;
import org.apache.james.lifecycle.api.Disposable;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.server.core.MimeMessageSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeMessageObjectMessageSource
implements MimeMessageSource,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MimeMessageObjectMessageSource.class);
    private final ObjectMessage message;
    private final SharedByteArrayInputStream in;
    private final String id;
    private byte[] content;

    public MimeMessageObjectMessageSource(ObjectMessage message) throws JMSException {
        this.message = message;
        this.id = message.getJMSMessageID();
        this.content = (byte[])message.getObject();
        this.in = new SharedByteArrayInputStream(this.content);
    }

    public long getMessageSize() throws IOException {
        return this.content.length;
    }

    public InputStream getInputStream() throws IOException {
        return this.in.newStream(0L, -1L);
    }

    public String getSourceId() {
        return this.id;
    }

    public void dispose() {
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        LifecycleUtil.dispose((Object)this.in);
        try {
            this.message.clearBody();
        }
        catch (JMSException e) {
            LOGGER.error("Error clearing JMS message body", (Throwable)e);
        }
        try {
            this.message.clearProperties();
        }
        catch (JMSException e) {
            LOGGER.error("Error clearing JMS message properties", (Throwable)e);
        }
        this.content = null;
    }
}

