/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp.datasources;

import java.io.IOException;
import java.util.Map;
import javax.naming.RefAddr;
import javax.naming.Reference;
import org.apache.commons.dbcp.datasources.InstanceKeyDataSource;
import org.apache.commons.dbcp.datasources.InstanceKeyObjectFactory;
import org.apache.commons.dbcp.datasources.PerUserPoolDataSource;

public class PerUserPoolDataSourceFactory
extends InstanceKeyObjectFactory {
    private static final String PER_USER_POOL_CLASSNAME = PerUserPoolDataSource.class.getName();

    @Override
    protected boolean isCorrectClass(String className) {
        return PER_USER_POOL_CLASSNAME.equals(className);
    }

    @Override
    protected InstanceKeyDataSource getNewInstance(Reference ref) throws IOException, ClassNotFoundException {
        byte[] serialized;
        PerUserPoolDataSource pupds = new PerUserPoolDataSource();
        RefAddr ra = ref.get("defaultMaxActive");
        if (ra != null && ra.getContent() != null) {
            pupds.setDefaultMaxActive(Integer.parseInt(ra.getContent().toString()));
        }
        if ((ra = ref.get("defaultMaxIdle")) != null && ra.getContent() != null) {
            pupds.setDefaultMaxIdle(Integer.parseInt(ra.getContent().toString()));
        }
        if ((ra = ref.get("defaultMaxWait")) != null && ra.getContent() != null) {
            pupds.setDefaultMaxWait(Integer.parseInt(ra.getContent().toString()));
        }
        if ((ra = ref.get("perUserDefaultAutoCommit")) != null && ra.getContent() != null) {
            serialized = (byte[])ra.getContent();
            pupds.perUserDefaultAutoCommit = (Map)PerUserPoolDataSourceFactory.deserialize(serialized);
        }
        if ((ra = ref.get("perUserDefaultTransactionIsolation")) != null && ra.getContent() != null) {
            serialized = (byte[])ra.getContent();
            pupds.perUserDefaultTransactionIsolation = (Map)PerUserPoolDataSourceFactory.deserialize(serialized);
        }
        if ((ra = ref.get("perUserMaxActive")) != null && ra.getContent() != null) {
            serialized = (byte[])ra.getContent();
            pupds.perUserMaxActive = (Map)PerUserPoolDataSourceFactory.deserialize(serialized);
        }
        if ((ra = ref.get("perUserMaxIdle")) != null && ra.getContent() != null) {
            serialized = (byte[])ra.getContent();
            pupds.perUserMaxIdle = (Map)PerUserPoolDataSourceFactory.deserialize(serialized);
        }
        if ((ra = ref.get("perUserMaxWait")) != null && ra.getContent() != null) {
            serialized = (byte[])ra.getContent();
            pupds.perUserMaxWait = (Map)PerUserPoolDataSourceFactory.deserialize(serialized);
        }
        if ((ra = ref.get("perUserDefaultReadOnly")) != null && ra.getContent() != null) {
            serialized = (byte[])ra.getContent();
            pupds.perUserDefaultReadOnly = (Map)PerUserPoolDataSourceFactory.deserialize(serialized);
        }
        return pupds;
    }
}

