/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.protocols.smtp.core;

import com.google.common.base.Preconditions;
import org.apache.james.core.Domain;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.core.Username;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookReturnCode;
import org.apache.james.protocols.smtp.hook.MailHook;
import org.apache.james.protocols.smtp.hook.RcptHook;

public abstract class AbstractSenderAuthIdentifyVerificationHook
implements MailHook,
RcptHook {
    private static final HookResult INVALID_AUTH = HookResult.builder().hookReturnCode(HookReturnCode.deny()).smtpReturnCode("503").smtpDescription(DSNStatus.getStatus(5, "7.1") + " Incorrect Authentication for Specified Email Address").build();
    private static final HookResult AUTH_REQUIRED = HookResult.builder().hookReturnCode(HookReturnCode.deny()).smtpReturnCode("530").smtpDescription(DSNStatus.getStatus(5, "7.1") + " Authentication Required").build();

    private boolean senderDoesNotMatchAuthUser(SMTPSession session, MaybeSender sender) {
        return session.getUsername() != null && (this.isAnonymous(sender) || !this.senderMatchSessionUser(sender, session) || !this.belongsToLocalDomain(sender));
    }

    private boolean unauthenticatedSenderIsLocalUser(SMTPSession session, MaybeSender sender) {
        return session.getUsername() == null && !session.isRelayingAllowed() && this.belongsToLocalDomain(sender);
    }

    protected HookResult doCheck(SMTPSession session, MaybeSender sender) {
        if (this.senderDoesNotMatchAuthUser(session, sender)) {
            return INVALID_AUTH;
        }
        if (this.unauthenticatedSenderIsLocalUser(session, sender)) {
            return AUTH_REQUIRED;
        }
        return HookResult.DECLINED;
    }

    @Override
    public HookResult doMail(SMTPSession session, MaybeSender sender) {
        return this.doCheck(session, sender);
    }

    @Override
    public HookResult doRcpt(SMTPSession session, MaybeSender sender, MailAddress rcpt) {
        return this.doCheck(session, sender);
    }

    private boolean isAnonymous(MaybeSender maybeSender) {
        return maybeSender == null || maybeSender.isNullSender();
    }

    private boolean senderMatchSessionUser(MaybeSender maybeSender, SMTPSession session) {
        Preconditions.checkArgument((!maybeSender.isNullSender() ? 1 : 0) != 0);
        Username authUser = session.getUsername();
        Username sender = this.getUser(maybeSender.get());
        return this.isSenderAllowed(authUser, sender);
    }

    private boolean belongsToLocalDomain(MaybeSender maybeSender) {
        return maybeSender.asOptional().map(MailAddress::getDomain).filter(this::isLocalDomain).isPresent();
    }

    protected abstract boolean isLocalDomain(Domain var1);

    protected abstract Username getUser(MailAddress var1);

    protected abstract boolean isSenderAllowed(Username var1, Username var2);
}

