/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.adapter.mailbox;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.apache.james.adapter.mailbox.MailboxManagerManagementMBean;
import org.apache.james.core.Username;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.Content;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MailboxMetaData;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.mailbox.model.search.MailboxQuery;
import org.apache.james.util.MDCBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailboxManagerManagement
extends StandardMBean
implements MailboxManagerManagementMBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailboxManagerManagement.class);
    private MailboxManager mailboxManager;

    @Inject
    public void setMailboxManager(@Named(value="mailboxmanager") MailboxManager mailboxManager) {
        this.mailboxManager = mailboxManager;
    }

    public MailboxManagerManagement() throws NotCompliantMBeanException {
        super(MailboxManagerManagementMBean.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean deleteMailboxes(String username) {
        boolean bl;
        MailboxSession session;
        block12: {
            this.checkString(username, "Username");
            session = null;
            Closeable closeable = MDCBuilder.create().addToContext("protocol", "CLI").addToContext("action", "deleteMailboxes").addToContext("concernedUser", username).build();
            try {
                session = this.mailboxManager.createSystemSession(Username.of((String)username));
                this.mailboxManager.startProcessingRequest(session);
                List<MailboxMetaData> mList = this.retrieveAllUserMailboxes(session);
                for (MailboxMetaData aMList : mList) {
                    this.mailboxManager.deleteMailbox(aMList.getPath(), session);
                }
                bl = true;
                if (closeable == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (closeable == null) throw throwable;
                    try {
                        closeable.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (MailboxException e) {
                    LOGGER.error("Error while remove mailboxes for user {}", (Object)username, (Object)e);
                    this.closeSession(session);
                    return false;
                }
                catch (IOException e) {
                    try {
                        throw new RuntimeException(e);
                    }
                    catch (Throwable throwable3) {
                        this.closeSession(session);
                        throw throwable3;
                    }
                }
            }
            closeable.close();
        }
        this.closeSession(session);
        return bl;
    }

    /*
     * Loose catch block
     */
    @Override
    public List<String> listMailboxes(String username) {
        this.checkString(username, "Username");
        List<String> boxes = new ArrayList<String>();
        MailboxSession session = null;
        try {
            try (Closeable closeable = MDCBuilder.create().addToContext("protocol", "CLI").addToContext("action", "listMailboxes").addToContext("concernedUser", username).build();){
                session = this.mailboxManager.createSystemSession(Username.of((String)username));
                this.mailboxManager.startProcessingRequest(session);
                List<MailboxMetaData> mList = this.retrieveAllUserMailboxes(session);
                boxes = (List)mList.stream().map(aMList -> aMList.getPath().getName()).sorted().collect(ImmutableList.toImmutableList());
            }
            this.closeSession(session);
        }
        catch (MailboxException e) {
            LOGGER.error("Error list mailboxes for user {}", (Object)username, (Object)e);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.closeSession(session);
        }
        return boxes;
    }

    @Override
    public MailboxId createMailbox(String namespace, String user, String name) {
        MailboxId mailboxId;
        MailboxSession session;
        block10: {
            this.checkMailboxArguments(namespace, user, name);
            Username username = Username.of((String)user);
            session = null;
            MailboxPath mailboxPath = new MailboxPath(namespace, username, name);
            Closeable closeable = MDCBuilder.create().addToContext("protocol", "CLI").addToContext("action", "createMailbox").addToContext("mailboxPath", mailboxPath.asString()).build();
            try {
                session = this.mailboxManager.createSystemSession(username);
                this.mailboxManager.startProcessingRequest(session);
                mailboxId = (MailboxId)this.mailboxManager.createMailbox(mailboxPath, session).orElseThrow(() -> new MailboxException("mailbox name is probably empty"));
                if (closeable == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (closeable != null) {
                            try {
                                closeable.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        LOGGER.error("Unable to create mailbox", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
                catch (Throwable throwable3) {
                    this.closeSession(session);
                    throw throwable3;
                }
            }
            closeable.close();
        }
        this.closeSession(session);
        return mailboxId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteMailbox(String namespace, String user, String name) {
        this.checkMailboxArguments(namespace, user, name);
        Username username = Username.of((String)user);
        MailboxSession session = null;
        MailboxPath mailboxPath = new MailboxPath(namespace, username, name);
        try {
            try (Closeable closeable = MDCBuilder.create().addToContext("protocol", "CLI").addToContext("action", "deleteMailbox").addToContext("mailboxPath", mailboxPath.asString()).build();){
                session = this.mailboxManager.createSystemSession(username);
                this.mailboxManager.startProcessingRequest(session);
                this.mailboxManager.deleteMailbox(mailboxPath, session);
            }
            this.closeSession(session);
        }
        catch (Exception e) {
            LOGGER.error("Unable to create mailbox", (Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importEmlFileToMailbox(String namespace, String user, String name, final String emlPath) {
        this.checkMailboxArguments(namespace, user, name);
        this.checkString(emlPath, "email file path name");
        Username username = Username.of((String)user);
        MailboxSession session = null;
        MailboxPath mailboxPath = new MailboxPath(namespace, username, name);
        try {
            try (Closeable closeable = MDCBuilder.create().addToContext("protocol", "CLI").addToContext("action", "importEmlFileToMailbox").addToContext("mailboxPath", mailboxPath.asString()).addToContext("emlPath", emlPath).build();){
                session = this.mailboxManager.createSystemSession(username);
                this.mailboxManager.startProcessingRequest(session);
                MessageManager messageManager = this.mailboxManager.getMailbox(mailboxPath, session);
                final File file = new File(emlPath);
                messageManager.appendMessage(MessageManager.AppendCommand.builder().recent().build(new Content(){

                    public InputStream getInputStream() throws IOException {
                        return new FileInputStream(emlPath);
                    }

                    public long size() {
                        return file.length();
                    }
                }), session);
            }
            this.closeSession(session);
        }
        catch (Exception e) {
            LOGGER.error("Unable to create mailbox", (Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    private void closeSession(MailboxSession session) {
        if (session != null) {
            this.mailboxManager.endProcessingRequest(session);
        }
    }

    private List<MailboxMetaData> retrieveAllUserMailboxes(MailboxSession session) throws MailboxException {
        return (List)this.mailboxManager.search(MailboxQuery.privateMailboxesBuilder((MailboxSession)session).matchesAllMailboxNames().build(), MailboxManager.MailboxSearchFetchType.Minimal, session).collect(ImmutableList.toImmutableList()).block();
    }

    private void checkMailboxArguments(String namespace, String user, String name) {
        this.checkString(namespace, "mailbox path namespace");
        this.checkString(user, "mailbox path user");
        this.checkString(name, "mailbox name");
    }

    private void checkString(String argument, String role) {
        Preconditions.checkNotNull((Object)argument, (String)"Provided %s should not be null.", (Object)role);
        Preconditions.checkArgument((!argument.equals("") ? 1 : 0) != 0, (String)"Provided %s should not be empty.", (Object)role);
    }
}

