/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.jpa.mail;

import com.github.fge.lambdas.Throwing;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.mail.Flags;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import org.apache.james.mailbox.ApplicableFlagBuilder;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.ModSeq;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.jpa.JPAId;
import org.apache.james.mailbox.jpa.JPATransactionalMapper;
import org.apache.james.mailbox.jpa.mail.JPAModSeqProvider;
import org.apache.james.mailbox.jpa.mail.JPAUidProvider;
import org.apache.james.mailbox.jpa.mail.MessageUtils;
import org.apache.james.mailbox.jpa.mail.model.JPAMailbox;
import org.apache.james.mailbox.jpa.mail.model.openjpa.AbstractJPAMailboxMessage;
import org.apache.james.mailbox.jpa.mail.model.openjpa.JPAEncryptedMailboxMessage;
import org.apache.james.mailbox.jpa.mail.model.openjpa.JPAMailboxMessage;
import org.apache.james.mailbox.jpa.mail.model.openjpa.JPAStreamingMailboxMessage;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.MailboxCounters;
import org.apache.james.mailbox.model.MailboxId;
import org.apache.james.mailbox.model.MessageMetaData;
import org.apache.james.mailbox.model.MessageRange;
import org.apache.james.mailbox.model.UpdatedFlags;
import org.apache.james.mailbox.store.FlagsUpdateCalculator;
import org.apache.james.mailbox.store.mail.MessageMapper;
import org.apache.james.mailbox.store.mail.model.MailboxMessage;
import org.apache.openjpa.persistence.ArgumentException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class JPAMessageMapper
extends JPATransactionalMapper
implements MessageMapper {
    private static final int UNLIMIT_MAX_SIZE = -1;
    private static final int UNLIMITED = -1;
    private final MessageUtils messageMetadataMapper;
    private final JPAUidProvider uidProvider;
    private final JPAModSeqProvider modSeqProvider;

    public JPAMessageMapper(JPAUidProvider uidProvider, JPAModSeqProvider modSeqProvider, EntityManagerFactory entityManagerFactory) {
        super(entityManagerFactory);
        this.messageMetadataMapper = new MessageUtils(uidProvider, modSeqProvider);
        this.uidProvider = uidProvider;
        this.modSeqProvider = modSeqProvider;
    }

    public MailboxCounters getMailboxCounters(Mailbox mailbox) throws MailboxException {
        return MailboxCounters.builder().mailboxId(mailbox.getMailboxId()).count(this.countMessagesInMailbox(mailbox)).unseen(this.countUnseenMessagesInMailbox(mailbox)).build();
    }

    public Flux<MessageUid> listAllMessageUids(Mailbox mailbox) {
        return Mono.fromCallable(() -> {
            try {
                JPAId mailboxId = (JPAId)mailbox.getMailboxId();
                Query query = this.getEntityManager().createNamedQuery("listUidsInMailbox").setParameter("idParam", (Object)mailboxId.getRawId());
                return query.getResultStream().map(result -> MessageUid.of((long)((Long)result)));
            }
            catch (PersistenceException e) {
                throw new MailboxException("Search of recent messages failed in mailbox " + mailbox, (Throwable)e);
            }
        }).flatMapMany(Flux::fromStream).subscribeOn(Schedulers.boundedElastic());
    }

    public Flux<MailboxMessage> findInMailboxReactive(Mailbox mailbox, MessageRange messageRange, MessageMapper.FetchType ftype, int limitAsInt) {
        return Flux.defer((Supplier)Throwing.supplier(() -> Flux.fromIterable(this.findAsList(mailbox.getMailboxId(), messageRange, limitAsInt))).sneakyThrow()).subscribeOn(Schedulers.boundedElastic());
    }

    public Iterator<MailboxMessage> findInMailbox(Mailbox mailbox, MessageRange set, MessageMapper.FetchType fType, int max) throws MailboxException {
        return this.findAsList(mailbox.getMailboxId(), set, max).iterator();
    }

    private List<MailboxMessage> findAsList(MailboxId mailboxId, MessageRange set, int max) throws MailboxException {
        try {
            MessageUid from = set.getUidFrom();
            MessageUid to = set.getUidTo();
            MessageRange.Type type = set.getType();
            JPAId jpaId = (JPAId)mailboxId;
            switch (type) {
                default: {
                    return this.findMessagesInMailbox(jpaId, max);
                }
                case FROM: {
                    return this.findMessagesInMailboxAfterUID(jpaId, from, max);
                }
                case ONE: {
                    return this.findMessagesInMailboxWithUID(jpaId, from);
                }
                case RANGE: 
            }
            return this.findMessagesInMailboxBetweenUIDs(jpaId, from, to, max);
        }
        catch (PersistenceException e) {
            throw new MailboxException("Search of MessageRange " + set + " failed in mailbox " + mailboxId.serialize(), (Throwable)e);
        }
    }

    public long countMessagesInMailbox(Mailbox mailbox) throws MailboxException {
        JPAId mailboxId = (JPAId)mailbox.getMailboxId();
        return this.countMessagesInMailbox(mailboxId);
    }

    private long countMessagesInMailbox(JPAId mailboxId) throws MailboxException {
        try {
            return (Long)this.getEntityManager().createNamedQuery("countMessagesInMailbox").setParameter("idParam", (Object)mailboxId.getRawId()).getSingleResult();
        }
        catch (PersistenceException e) {
            throw new MailboxException("Count of messages failed in mailbox " + mailboxId, (Throwable)e);
        }
    }

    public long countUnseenMessagesInMailbox(Mailbox mailbox) throws MailboxException {
        JPAId mailboxId = (JPAId)mailbox.getMailboxId();
        return this.countUnseenMessagesInMailbox(mailboxId);
    }

    private long countUnseenMessagesInMailbox(JPAId mailboxId) throws MailboxException {
        try {
            return (Long)this.getEntityManager().createNamedQuery("countUnseenMessagesInMailbox").setParameter("idParam", (Object)mailboxId.getRawId()).getSingleResult();
        }
        catch (PersistenceException e) {
            throw new MailboxException("Count of useen messages failed in mailbox " + mailboxId, (Throwable)e);
        }
    }

    public void delete(Mailbox mailbox, MailboxMessage message) throws MailboxException {
        try {
            AbstractJPAMailboxMessage jpaMessage = (AbstractJPAMailboxMessage)this.getEntityManager().find(AbstractJPAMailboxMessage.class, (Object)this.buildKey(mailbox, message));
            this.getEntityManager().remove((Object)jpaMessage);
        }
        catch (PersistenceException e) {
            throw new MailboxException("Delete of message " + message + " failed in mailbox " + mailbox, (Throwable)e);
        }
    }

    private AbstractJPAMailboxMessage.MailboxIdUidKey buildKey(Mailbox mailbox, MailboxMessage message) {
        JPAId mailboxId = (JPAId)mailbox.getMailboxId();
        AbstractJPAMailboxMessage.MailboxIdUidKey key = new AbstractJPAMailboxMessage.MailboxIdUidKey();
        key.mailbox = mailboxId.getRawId();
        key.uid = message.getUid().asLong();
        return key;
    }

    public MessageUid findFirstUnseenMessageUid(Mailbox mailbox) throws MailboxException {
        try {
            JPAId mailboxId = (JPAId)mailbox.getMailboxId();
            Query query = this.getEntityManager().createNamedQuery("findUnseenMessagesInMailboxOrderByUid").setParameter("idParam", (Object)mailboxId.getRawId());
            query.setMaxResults(1);
            List result = query.getResultList();
            if (result.isEmpty()) {
                return null;
            }
            return ((MailboxMessage)result.get(0)).getUid();
        }
        catch (PersistenceException e) {
            throw new MailboxException("Search of first unseen message failed in mailbox " + mailbox, (Throwable)e);
        }
    }

    public List<MessageUid> findRecentMessageUidsInMailbox(Mailbox mailbox) throws MailboxException {
        try {
            JPAId mailboxId = (JPAId)mailbox.getMailboxId();
            Query query = this.getEntityManager().createNamedQuery("findRecentMessageUidsInMailbox").setParameter("idParam", (Object)mailboxId.getRawId());
            List resultList = query.getResultList();
            ImmutableList.Builder results = ImmutableList.builder();
            Iterator iterator = resultList.iterator();
            while (iterator.hasNext()) {
                long result = (Long)iterator.next();
                results.add((Object)MessageUid.of((long)result));
            }
            return results.build();
        }
        catch (PersistenceException e) {
            throw new MailboxException("Search of recent messages failed in mailbox " + mailbox, (Throwable)e);
        }
    }

    public List<MessageUid> retrieveMessagesMarkedForDeletion(Mailbox mailbox, MessageRange messageRange) throws MailboxException {
        try {
            JPAId mailboxId = (JPAId)mailbox.getMailboxId();
            List<MailboxMessage> messages = this.findDeletedMessages(messageRange, mailboxId);
            return this.getUidList(messages);
        }
        catch (PersistenceException e) {
            throw new MailboxException("Search of MessageRange " + messageRange + " failed in mailbox " + mailbox, (Throwable)e);
        }
    }

    private List<MailboxMessage> findDeletedMessages(MessageRange messageRange, JPAId mailboxId) {
        MessageUid from = messageRange.getUidFrom();
        MessageUid to = messageRange.getUidTo();
        switch (messageRange.getType()) {
            case ONE: {
                return this.findDeletedMessagesInMailboxWithUID(mailboxId, from);
            }
            case RANGE: {
                return this.findDeletedMessagesInMailboxBetweenUIDs(mailboxId, from, to);
            }
            case FROM: {
                return this.findDeletedMessagesInMailboxAfterUID(mailboxId, from);
            }
            case ALL: {
                return this.findDeletedMessagesInMailbox(mailboxId);
            }
        }
        throw new RuntimeException("Cannot find deleted messages, range type " + messageRange.getType() + " doesn't exist");
    }

    public Map<MessageUid, MessageMetaData> deleteMessages(Mailbox mailbox, List<MessageUid> uids) throws MailboxException {
        JPAId mailboxId = (JPAId)mailbox.getMailboxId();
        HashMap<MessageUid, MessageMetaData> data = new HashMap<MessageUid, MessageMetaData>();
        List ranges = MessageRange.toRanges(uids);
        ranges.forEach(Throwing.consumer(range -> {
            List<MailboxMessage> messages = this.findAsList(mailboxId, (MessageRange)range, -1);
            data.putAll(this.createMetaData(messages));
            this.deleteMessages((MessageRange)range, mailboxId);
        }).sneakyThrow());
        return data;
    }

    private void deleteMessages(MessageRange messageRange, JPAId mailboxId) {
        MessageUid from = messageRange.getUidFrom();
        MessageUid to = messageRange.getUidTo();
        switch (messageRange.getType()) {
            case ONE: {
                this.deleteMessagesInMailboxWithUID(mailboxId, from);
                break;
            }
            case RANGE: {
                this.deleteMessagesInMailboxBetweenUIDs(mailboxId, from, to);
                break;
            }
            case FROM: {
                this.deleteMessagesInMailboxAfterUID(mailboxId, from);
                break;
            }
            case ALL: {
                this.deleteMessagesInMailbox(mailboxId);
                break;
            }
            default: {
                throw new RuntimeException("Cannot delete messages, range type " + messageRange.getType() + " doesn't exist");
            }
        }
    }

    public MessageMetaData move(Mailbox mailbox, MailboxMessage original) throws MailboxException {
        JPAId originalMailboxId = (JPAId)original.getMailboxId();
        JPAMailbox originalMailbox = (JPAMailbox)this.getEntityManager().find(JPAMailbox.class, (Object)originalMailboxId.getRawId());
        MessageMetaData messageMetaData = this.copy(mailbox, original);
        this.delete(originalMailbox.toMailbox(), original);
        return messageMetaData;
    }

    public MessageMetaData add(Mailbox mailbox, MailboxMessage message) throws MailboxException {
        this.messageMetadataMapper.enrichMessage(mailbox, message);
        return this.save(mailbox, message);
    }

    public Iterator<UpdatedFlags> updateFlags(Mailbox mailbox, FlagsUpdateCalculator flagsUpdateCalculator, MessageRange set) throws MailboxException {
        Iterator<MailboxMessage> messages = this.findInMailbox(mailbox, set, MessageMapper.FetchType.METADATA, -1);
        MessageUtils.MessageChangedFlags messageChangedFlags = this.messageMetadataMapper.updateFlags(mailbox, flagsUpdateCalculator, messages);
        for (MailboxMessage mailboxMessage : messageChangedFlags.getChangedFlags()) {
            this.save(mailbox, mailboxMessage);
        }
        return messageChangedFlags.getUpdatedFlags();
    }

    public MessageMetaData copy(Mailbox mailbox, MailboxMessage original) throws MailboxException {
        return this.copy(mailbox, this.uidProvider.nextUid(mailbox), this.modSeqProvider.nextModSeq(mailbox), original);
    }

    public Optional<MessageUid> getLastUid(Mailbox mailbox) throws MailboxException {
        return this.uidProvider.lastUid(mailbox, this.getEntityManager());
    }

    public ModSeq getHighestModSeq(Mailbox mailbox) throws MailboxException {
        return this.modSeqProvider.highestModSeq(mailbox.getMailboxId(), this.getEntityManager());
    }

    public Flags getApplicableFlag(Mailbox mailbox) throws MailboxException {
        JPAId jpaId = (JPAId)mailbox.getMailboxId();
        ApplicableFlagBuilder builder = ApplicableFlagBuilder.builder();
        List flags = this.getEntityManager().createNativeQuery("SELECT DISTINCT USERFLAG_NAME FROM JAMES_MAIL_USERFLAG WHERE MAILBOX_ID=?").setParameter(1, (Object)jpaId.getRawId()).getResultList();
        flags.forEach(xva$0 -> builder.add(new String[]{xva$0}));
        return builder.build();
    }

    private MessageMetaData copy(Mailbox mailbox, MessageUid uid, ModSeq modSeq, MailboxMessage original) throws MailboxException {
        JPAMailbox currentMailbox = JPAMailbox.from(mailbox);
        AbstractJPAMailboxMessage copy = original instanceof JPAStreamingMailboxMessage ? new JPAStreamingMailboxMessage(currentMailbox, uid, modSeq, original) : (original instanceof JPAEncryptedMailboxMessage ? new JPAEncryptedMailboxMessage(currentMailbox, uid, modSeq, original) : new JPAMailboxMessage(currentMailbox, uid, modSeq, original));
        return this.save(mailbox, copy);
    }

    protected MessageMetaData save(Mailbox mailbox, MailboxMessage message) throws MailboxException {
        try {
            JPAId mailboxId = (JPAId)mailbox.getMailboxId();
            JPAMailbox currentMailbox = (JPAMailbox)this.getEntityManager().find(JPAMailbox.class, (Object)mailboxId.getRawId());
            if (message instanceof AbstractJPAMailboxMessage) {
                ((AbstractJPAMailboxMessage)message).setMailbox(currentMailbox);
                this.getEntityManager().persist((Object)message);
                return message.metaData();
            }
            JPAMailboxMessage persistData = new JPAMailboxMessage(currentMailbox, message.getUid(), message.getModSeq(), message);
            persistData.setFlags(message.createFlags());
            this.getEntityManager().persist((Object)persistData);
            return persistData.metaData();
        }
        catch (PersistenceException | ArgumentException e) {
            throw new MailboxException("Save of message " + message + " failed in mailbox " + mailbox, e);
        }
    }

    private List<MailboxMessage> findMessagesInMailboxAfterUID(JPAId mailboxId, MessageUid from, int batchSize) {
        Query query = this.getEntityManager().createNamedQuery("findMessagesInMailboxAfterUID").setParameter("idParam", (Object)mailboxId.getRawId()).setParameter("uidParam", (Object)from.asLong());
        if (batchSize > 0) {
            query.setMaxResults(batchSize);
        }
        return query.getResultList();
    }

    private List<MailboxMessage> findMessagesInMailboxWithUID(JPAId mailboxId, MessageUid from) {
        return this.getEntityManager().createNamedQuery("findMessagesInMailboxWithUID").setParameter("idParam", (Object)mailboxId.getRawId()).setParameter("uidParam", (Object)from.asLong()).setMaxResults(1).getResultList();
    }

    private List<MailboxMessage> findMessagesInMailboxBetweenUIDs(JPAId mailboxId, MessageUid from, MessageUid to, int batchSize) {
        Query query = this.getEntityManager().createNamedQuery("findMessagesInMailboxBetweenUIDs").setParameter("idParam", (Object)mailboxId.getRawId()).setParameter("fromParam", (Object)from.asLong()).setParameter("toParam", (Object)to.asLong());
        if (batchSize > 0) {
            query.setMaxResults(batchSize);
        }
        return query.getResultList();
    }

    private List<MailboxMessage> findMessagesInMailbox(JPAId mailboxId, int batchSize) {
        Query query = this.getEntityManager().createNamedQuery("findMessagesInMailbox").setParameter("idParam", (Object)mailboxId.getRawId());
        if (batchSize > 0) {
            query.setMaxResults(batchSize);
        }
        return query.getResultList();
    }

    private Map<MessageUid, MessageMetaData> createMetaData(List<MailboxMessage> uids) {
        HashMap<MessageUid, MessageMetaData> data = new HashMap<MessageUid, MessageMetaData>();
        for (MailboxMessage m : uids) {
            data.put(m.getUid(), m.metaData());
        }
        return data;
    }

    private List<MessageUid> getUidList(List<MailboxMessage> messages) {
        return (List)messages.stream().map(message -> message.getUid()).collect(ImmutableList.toImmutableList());
    }

    private int deleteMessagesInMailbox(JPAId mailboxId) {
        return this.getEntityManager().createNamedQuery("deleteMessagesInMailbox").setParameter("idParam", (Object)mailboxId.getRawId()).executeUpdate();
    }

    private int deleteMessagesInMailboxAfterUID(JPAId mailboxId, MessageUid from) {
        return this.getEntityManager().createNamedQuery("deleteMessagesInMailboxAfterUID").setParameter("idParam", (Object)mailboxId.getRawId()).setParameter("uidParam", (Object)from.asLong()).executeUpdate();
    }

    private int deleteMessagesInMailboxWithUID(JPAId mailboxId, MessageUid from) {
        return this.getEntityManager().createNamedQuery("deleteMessagesInMailboxWithUID").setParameter("idParam", (Object)mailboxId.getRawId()).setParameter("uidParam", (Object)from.asLong()).executeUpdate();
    }

    private int deleteMessagesInMailboxBetweenUIDs(JPAId mailboxId, MessageUid from, MessageUid to) {
        return this.getEntityManager().createNamedQuery("deleteMessagesInMailboxBetweenUIDs").setParameter("idParam", (Object)mailboxId.getRawId()).setParameter("fromParam", (Object)from.asLong()).setParameter("toParam", (Object)to.asLong()).executeUpdate();
    }

    private List<MailboxMessage> findDeletedMessagesInMailbox(JPAId mailboxId) {
        return this.getEntityManager().createNamedQuery("findDeletedMessagesInMailbox").setParameter("idParam", (Object)mailboxId.getRawId()).getResultList();
    }

    private List<MailboxMessage> findDeletedMessagesInMailboxAfterUID(JPAId mailboxId, MessageUid from) {
        return this.getEntityManager().createNamedQuery("findDeletedMessagesInMailboxAfterUID").setParameter("idParam", (Object)mailboxId.getRawId()).setParameter("uidParam", (Object)from.asLong()).getResultList();
    }

    private List<MailboxMessage> findDeletedMessagesInMailboxWithUID(JPAId mailboxId, MessageUid from) {
        return this.getEntityManager().createNamedQuery("findDeletedMessagesInMailboxWithUID").setParameter("idParam", (Object)mailboxId.getRawId()).setParameter("uidParam", (Object)from.asLong()).setMaxResults(1).getResultList();
    }

    private List<MailboxMessage> findDeletedMessagesInMailboxBetweenUIDs(JPAId mailboxId, MessageUid from, MessageUid to) {
        return this.getEntityManager().createNamedQuery("findDeletedMessagesInMailboxBetweenUIDs").setParameter("idParam", (Object)mailboxId.getRawId()).setParameter("fromParam", (Object)from.asLong()).setParameter("toParam", (Object)to.asLong()).getResultList();
    }
}

