/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.pushsubscription;

import eu.timepit.refined.api.Refined;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import org.apache.james.jmap.api.model.PushSubscriptionServerURL;
import org.apache.james.jmap.pushsubscription.DefaultWebPushClient$;
import org.apache.james.jmap.pushsubscription.PushClientConfiguration;
import org.apache.james.jmap.pushsubscription.PushRequest;
import org.apache.james.jmap.pushsubscription.PushUrgency;
import org.apache.james.jmap.pushsubscription.PushUrgency$;
import org.apache.james.jmap.pushsubscription.WebPushClient;
import org.apache.james.jmap.pushsubscription.WebPushClientHeader$;
import org.apache.james.jmap.pushsubscription.WebPushInvalidRequestException;
import org.apache.james.jmap.pushsubscription.WebPushTemporarilyUnavailableException;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SynchronousSink;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import reactor.core.scheduler.Schedulers;
import reactor.netty.ByteBufMono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientResponse;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dt!\u0002\t\u0012\u0011\u0003ab!\u0002\u0010\u0012\u0011\u0003y\u0002\"\u0002\u0014\u0002\t\u00039\u0003b\u0002\u0015\u0002\u0005\u0004%\t!\u000b\u0005\u0007[\u0005\u0001\u000b\u0011\u0002\u0016\t\u000b9\nA\u0011B\u0018\u0007\ty\t\u0002!\u0011\u0005\t{\u0019\u0011\t\u0011)A\u0005}!)aE\u0002C\u0001\u000b\"9\u0011K\u0002b\u0001\n\u0003\u0011\u0006BB*\u0007A\u0003%\u0001\u0007C\u0003U\r\u0011\u0005S\u000bC\u0003o\r\u0011%q\u000eC\u0003o\r\u0011%!\u0010C\u0004\u0002\u001a\u0019!I!a\u0007\t\u000f\u0005%c\u0001\"\u0003\u0002L\u0005!B)\u001a4bk2$x+\u001a2QkND7\t\\5f]RT!AE\n\u0002!A,8\u000f[:vEN\u001c'/\u001b9uS>t'B\u0001\u000b\u0016\u0003\u0011QW.\u00199\u000b\u0005Y9\u0012!\u00026b[\u0016\u001c(B\u0001\r\u001a\u0003\u0019\t\u0007/Y2iK*\t!$A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002\u001e\u00035\t\u0011C\u0001\u000bEK\u001a\fW\u000f\u001c;XK\n\u0004Vo\u001d5DY&,g\u000e^\n\u0003\u0003\u0001\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u001d\u0003\u0015\u0002Vk\u0015%`'\u0016\u0013f+\u0012*`\u000bJ\u0013vJU0S\u000bN\u0003vJT*F?6\u000b\u0005l\u0018'F\u001d\u001e#\u0006*F\u0001+!\t\t3&\u0003\u0002-E\t\u0019\u0011J\u001c;\u0002MA+6\u000bS0T\u000bJ3VIU0F%J{%k\u0018*F'B{ejU#`\u001b\u0006Cv\fT#O\u000fRC\u0005%A\bck&dG\r\u0013;ua\u000ec\u0017.\u001a8u)\t\u0001D\b\u0005\u00022u5\t!G\u0003\u00024i\u000511\r\\5f]RT!!\u000e\u001c\u0002\t!$H\u000f\u001d\u0006\u0003oa\nQA\\3uifT\u0011!O\u0001\be\u0016\f7\r^8s\u0013\tY$G\u0001\u0006IiR\u00048\t\\5f]RDQ!P\u0003A\u0002y\nQbY8oM&<WO]1uS>t\u0007CA\u000f@\u0013\t\u0001\u0015CA\fQkND7\t\\5f]R\u001cuN\u001c4jOV\u0014\u0018\r^5p]N\u0019a\u0001\t\"\u0011\u0005u\u0019\u0015B\u0001#\u0012\u000559VM\u0019)vg\"\u001cE.[3oiR\u0011ai\u0012\t\u0003;\u0019AQ!\u0010\u0005A\u0002yB#\u0001C%\u0011\u0005){U\"A&\u000b\u00051k\u0015AB5oU\u0016\u001cGOC\u0001O\u0003\u0015Q\u0017M^1y\u0013\t\u00016J\u0001\u0004J]*,7\r^\u0001\u000bQR$\bo\u00117jK:$X#\u0001\u0019\u0002\u0017!$H\u000f]\"mS\u0016tG\u000fI\u0001\u0005aV\u001c\b\u000eF\u0002W?&\u00042a\u0016.]\u001b\u0005A&BA-\u001a\u0003=\u0011X-Y2uSZ,7\u000f\u001e:fC6\u001c\u0018BA.Y\u0005%\u0001VO\u00197jg\",'\u000f\u0005\u0002\";&\u0011aL\t\u0002\u0005+:LG\u000fC\u0003a\u0017\u0001\u0007\u0011-A\u0007qkND7+\u001a:wKJ,&\u000f\u001c\t\u0003E\u001el\u0011a\u0019\u0006\u0003I\u0016\fQ!\\8eK2T!AZ\n\u0002\u0007\u0005\u0004\u0018.\u0003\u0002iG\nI\u0002+^:i'V\u00147o\u0019:jaRLwN\\*feZ,'/\u0016*M\u0011\u0015Q7\u00021\u0001l\u0003\u001d\u0011X-];fgR\u0004\"!\b7\n\u00055\f\"a\u0003)vg\"\u0014V-];fgR\f\u0001B^1mS\u0012\fG/\u001a\u000b\u0003af\u00042!]<b\u001b\u0005\u0011(BA:u\u0003%\u0001XO\u00197jg\",'O\u0003\u0002$k*\u0011a\u000fO\u0001\u0005G>\u0014X-\u0003\u0002ye\n)1+T8o_\")\u0001\r\u0004a\u0001CR)10a\u0005\u0002\u0016A!Ap`A\u0002\u001b\u0005i(B\u0001@#\u0003\u0011)H/\u001b7\n\u0007\u0005\u0005QPA\u0002Uef\u0004B!!\u0002\u0002\u00105\u0011\u0011q\u0001\u0006\u0005\u0003\u0013\tY!A\u0002oKRT!!!\u0004\u0002\t)\fg/Y\u0005\u0005\u0003#\t9AA\u0006J]\u0016$\u0018\t\u001a3sKN\u001c\b\"\u00021\u000e\u0001\u0004\t\u0007bBA\f\u001b\u0001\u0007\u00111A\u0001\fS:,G/\u00113ee\u0016\u001c8/\u0001\rbMR,'\u000f\u0013+U!J+7\u000f]8og\u0016D\u0015M\u001c3mKJ$b!!\b\u00024\u0005u\u0002CBA\u0010\u0003G\t9#\u0004\u0002\u0002\")\u00111/^\u0005\u0005\u0003K\t\tC\u0001\u0003N_:|\u0007\u0003BA\u0015\u0003_i!!a\u000b\u000b\t\u00055\u00121B\u0001\u0005Y\u0006tw-\u0003\u0003\u00022\u0005-\"\u0001\u0002,pS\u0012Dq!!\u000e\u000f\u0001\u0004\t9$\u0001\u0007iiR\u0004(+Z:q_:\u001cX\rE\u00022\u0003sI1!a\u000f3\u0005IAE\u000f\u001e9DY&,g\u000e\u001e*fgB|gn]3\t\u000f\u0005}b\u00021\u0001\u0002B\u00059A-\u0019;b\u0005V4\u0007\u0003BA\"\u0003\u000bj\u0011AN\u0005\u0004\u0003\u000f2$a\u0003\"zi\u0016\u0014UOZ'p]>\f\u0011\u0003\u001d:f!J|7-Z:tS:<G)\u0019;b)\u0011\ti%!\u001a\u0011\r\u0005}\u00111EA(!\u0011\t\t&a\u0018\u000f\t\u0005M\u00131\f\t\u0004\u0003+\u0012SBAA,\u0015\r\tIfG\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005u#%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003C\n\u0019G\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003;\u0012\u0003bBA \u001f\u0001\u0007\u0011\u0011\t")
public class DefaultWebPushClient
implements WebPushClient {
    private final PushClientConfiguration configuration;
    private final HttpClient httpClient;

    public static int PUSH_SERVER_ERROR_RESPONSE_MAX_LENGTH() {
        return DefaultWebPushClient$.MODULE$.PUSH_SERVER_ERROR_RESPONSE_MAX_LENGTH();
    }

    public HttpClient httpClient() {
        return this.httpClient;
    }

    @Override
    public Publisher<BoxedUnit> push(PushSubscriptionServerURL pushServerUrl, PushRequest request) {
        return this.validate(pushServerUrl).flatMap((Function1 & Serializable)url -> {
            Mono mono = ((HttpClient.RequestSender)this.httpClient().headers(builder -> {
                builder.add(WebPushClientHeader$.MODULE$.TIME_TO_LIVE(), (Object)request.ttl());
                builder.add(WebPushClientHeader$.MODULE$.MESSAGE_URGENCY(), (Object)((PushUrgency)request.urgency().getOrElse((Function0 & Serializable)() -> PushUrgency$.MODULE$.default())).value());
                request.topic().foreach((Function1 & Serializable)t -> builder.add(WebPushClientHeader$.MODULE$.TOPIC(), (Object)((String)((Refined)t).value())));
                request.contentCoding().foreach((Function1 & Serializable)f -> builder.add(WebPushClientHeader$.MODULE$.CONTENT_ENCODING(), (Object)f.value()));
            }).post().uri(url.value().toString())).send((Publisher)SMono$.MODULE$.just((Object)Unpooled.wrappedBuffer((byte[])request.payload()))).responseSingle((httpResponse, dataBuf) -> this.afterHTTPResponseHandler((HttpClientResponse)httpResponse, (ByteBufMono)dataBuf));
            SMono$.MODULE$.empty();
            return SMono$.MODULE$.apply((Publisher)mono.thenReturn((Object)BoxedUnit.UNIT));
        });
    }

    private SMono<PushSubscriptionServerURL> validate(PushSubscriptionServerURL pushServerUrl) {
        if (this.configuration.preventServerSideRequestForgery()) {
            return SMono$.MODULE$.just((Object)pushServerUrl.value().getHost()).flatMap((Function1 & Serializable)host -> SMono$.MODULE$.fromCallable(() -> InetAddress.getByName(host)).subscribeOn(Schedulers.elastic())).handle((Function2 & Serializable)(inetAddress, sink) -> {
                DefaultWebPushClient.$anonfun$validate$3(this, pushServerUrl, inetAddress, sink);
                return BoxedUnit.UNIT;
            }).then(SMono$.MODULE$.just((Object)pushServerUrl));
        }
        return SMono$.MODULE$.just((Object)pushServerUrl);
    }

    private Try<InetAddress> validate(PushSubscriptionServerURL pushServerUrl, InetAddress inetAddress) {
        InetAddress inetAddress2 = inetAddress;
        if (inetAddress2.isSiteLocalAddress()) {
            return new Failure((Throwable)new IllegalArgumentException(new StringBuilder(117).append("JMAP Push subscription ").append(pushServerUrl).append(" is targeting a site local address ").append(inetAddress).append(". This could be an attempt for server-side request forgery.").toString()));
        }
        if (inetAddress2.isLoopbackAddress()) {
            return new Failure((Throwable)new IllegalArgumentException(new StringBuilder(115).append("JMAP Push subscription ").append(pushServerUrl).append(" is targeting a loopback address ").append(inetAddress).append(". This could be an attempt for server-side request forgery.").toString()));
        }
        if (inetAddress2.isLinkLocalAddress()) {
            return new Failure((Throwable)new IllegalArgumentException(new StringBuilder(117).append("JMAP Push subscription ").append(pushServerUrl).append(" is targeting a link local address ").append(inetAddress).append(". This could be an attempt for server-side request forgery.").toString()));
        }
        return new Success((Object)inetAddress);
    }

    private Mono<Void> afterHTTPResponseHandler(HttpClientResponse httpResponse, ByteBufMono dataBuf) {
        return Mono.just((Object)httpResponse.status()).flatMap(x0$1 -> {
            HttpResponseStatus httpResponseStatus = x0$1;
            HttpResponseStatus httpResponseStatus2 = HttpResponseStatus.CREATED;
            HttpResponseStatus httpResponseStatus3 = httpResponseStatus;
            if (!(httpResponseStatus2 != null ? !httpResponseStatus2.equals(httpResponseStatus3) : httpResponseStatus3 != null)) {
                return Mono.empty();
            }
            HttpResponseStatus httpResponseStatus4 = HttpResponseStatus.BAD_REQUEST;
            HttpResponseStatus httpResponseStatus5 = httpResponseStatus;
            if (!(httpResponseStatus4 != null ? !httpResponseStatus4.equals(httpResponseStatus5) : httpResponseStatus5 != null)) {
                return this.preProcessingData(dataBuf).flatMap(string2 -> Mono.error((Throwable)new WebPushInvalidRequestException((String)string2)));
            }
            return this.preProcessingData(dataBuf).flatMap(string2 -> Mono.error((Throwable)new WebPushTemporarilyUnavailableException((String)string2)));
        }).then();
    }

    private Mono<String> preProcessingData(ByteBufMono dataBuf) {
        return dataBuf.asString(StandardCharsets.UTF_8).switchIfEmpty(Mono.just((Object)"")).map(content -> {
            if (content.length() > DefaultWebPushClient$.MODULE$.PUSH_SERVER_ERROR_RESPONSE_MAX_LENGTH()) {
                return content.substring(DefaultWebPushClient$.MODULE$.PUSH_SERVER_ERROR_RESPONSE_MAX_LENGTH());
            }
            return content;
        });
    }

    public static final /* synthetic */ void $anonfun$validate$3(DefaultWebPushClient $this, PushSubscriptionServerURL pushServerUrl$1, InetAddress inetAddress, SynchronousSink sink) {
        $this.validate(pushServerUrl$1, inetAddress).fold((Function1 & Serializable)x$1 -> {
            sink.error(x$1);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable)x$1 -> {
            sink.next((Object)x$1);
            return BoxedUnit.UNIT;
        });
    }

    @Inject
    public DefaultWebPushClient(PushClientConfiguration configuration) {
        this.configuration = configuration;
        this.httpClient = DefaultWebPushClient$.MODULE$.org$apache$james$jmap$pushsubscription$DefaultWebPushClient$$buildHttpClient(configuration);
    }
}

