/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import com.google.crypto.tink.Aead;
import com.google.crypto.tink.Mac;
import com.google.crypto.tink.subtle.AesCtrJceCipher;
import com.google.crypto.tink.subtle.Bytes;
import com.google.crypto.tink.subtle.IndCpaCipher;
import com.google.crypto.tink.subtle.PrfHmacJce;
import com.google.crypto.tink.subtle.PrfMac;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import javax.crypto.spec.SecretKeySpec;

public final class EncryptThenAuthenticate
implements Aead {
    private final IndCpaCipher cipher;
    private final Mac mac;
    private final int macLength;

    public EncryptThenAuthenticate(IndCpaCipher cipher, Mac mac, int macLength) {
        this.cipher = cipher;
        this.mac = mac;
        this.macLength = macLength;
    }

    public static Aead newAesCtrHmac(byte[] aesCtrKey, int ivSize, String hmacAlgorithm, byte[] hmacKey, int tagSize) throws GeneralSecurityException {
        AesCtrJceCipher cipher = new AesCtrJceCipher(aesCtrKey, ivSize);
        SecretKeySpec hmacKeySpec = new SecretKeySpec(hmacKey, "HMAC");
        PrfMac hmac = new PrfMac(new PrfHmacJce(hmacAlgorithm, hmacKeySpec), tagSize);
        return new EncryptThenAuthenticate(cipher, hmac, tagSize);
    }

    @Override
    public byte[] encrypt(byte[] plaintext, byte[] associatedData) throws GeneralSecurityException {
        byte[] ciphertext = this.cipher.encrypt(plaintext);
        byte[] aad = associatedData;
        if (aad == null) {
            aad = new byte[]{};
        }
        byte[] aadLengthInBits = Arrays.copyOf(ByteBuffer.allocate(8).putLong(8L * (long)aad.length).array(), 8);
        byte[] macValue = this.mac.computeMac(Bytes.concat(aad, ciphertext, aadLengthInBits));
        return Bytes.concat(ciphertext, macValue);
    }

    @Override
    public byte[] decrypt(byte[] ciphertext, byte[] associatedData) throws GeneralSecurityException {
        if (ciphertext.length < this.macLength) {
            throw new GeneralSecurityException("ciphertext too short");
        }
        byte[] rawCiphertext = Arrays.copyOfRange(ciphertext, 0, ciphertext.length - this.macLength);
        byte[] macValue = Arrays.copyOfRange(ciphertext, ciphertext.length - this.macLength, ciphertext.length);
        byte[] aad = associatedData;
        if (aad == null) {
            aad = new byte[]{};
        }
        byte[] aadLengthInBits = Arrays.copyOf(ByteBuffer.allocate(8).putLong(8L * (long)aad.length).array(), 8);
        this.mac.verifyMac(macValue, Bytes.concat(aad, rawCiphertext, aadLengthInBits));
        return this.cipher.decrypt(rawCiphertext);
    }
}

