/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import com.google.crypto.tink.config.TinkFips;
import com.google.crypto.tink.subtle.EngineFactory;
import com.google.crypto.tink.subtle.IndCpaCipher;
import com.google.crypto.tink.subtle.Random;
import com.google.crypto.tink.subtle.Validators;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public final class AesCtrJceCipher
implements IndCpaCipher {
    public static final TinkFips.AlgorithmFipsCompatibility FIPS = TinkFips.AlgorithmFipsCompatibility.ALGORITHM_REQUIRES_BORINGCRYPTO;
    private static final ThreadLocal<Cipher> localCipher = new ThreadLocal<Cipher>(){

        @Override
        protected Cipher initialValue() {
            try {
                return EngineFactory.CIPHER.getInstance(AesCtrJceCipher.CIPHER_ALGORITHM);
            }
            catch (GeneralSecurityException ex) {
                throw new IllegalStateException(ex);
            }
        }
    };
    private static final String KEY_ALGORITHM = "AES";
    private static final String CIPHER_ALGORITHM = "AES/CTR/NoPadding";
    private static final int MIN_IV_SIZE_IN_BYTES = 12;
    private final SecretKeySpec keySpec;
    private final int ivSize;
    private final int blockSize;

    public AesCtrJceCipher(byte[] key, int ivSize) throws GeneralSecurityException {
        if (!FIPS.isCompatible()) {
            throw new GeneralSecurityException("Can not use AES-CTR in FIPS-mode, as BoringCrypto module is not available.");
        }
        Validators.validateAesKeySize(key.length);
        this.keySpec = new SecretKeySpec(key, KEY_ALGORITHM);
        this.blockSize = localCipher.get().getBlockSize();
        if (ivSize < 12 || ivSize > this.blockSize) {
            throw new GeneralSecurityException("invalid IV size");
        }
        this.ivSize = ivSize;
    }

    @Override
    public byte[] encrypt(byte[] plaintext) throws GeneralSecurityException {
        if (plaintext.length > Integer.MAX_VALUE - this.ivSize) {
            throw new GeneralSecurityException("plaintext length can not exceed " + (Integer.MAX_VALUE - this.ivSize));
        }
        byte[] ciphertext = new byte[this.ivSize + plaintext.length];
        byte[] iv = Random.randBytes(this.ivSize);
        System.arraycopy(iv, 0, ciphertext, 0, this.ivSize);
        this.doCtr(plaintext, 0, plaintext.length, ciphertext, this.ivSize, iv, true);
        return ciphertext;
    }

    @Override
    public byte[] decrypt(byte[] ciphertext) throws GeneralSecurityException {
        if (ciphertext.length < this.ivSize) {
            throw new GeneralSecurityException("ciphertext too short");
        }
        byte[] iv = new byte[this.ivSize];
        System.arraycopy(ciphertext, 0, iv, 0, this.ivSize);
        byte[] plaintext = new byte[ciphertext.length - this.ivSize];
        this.doCtr(ciphertext, this.ivSize, ciphertext.length - this.ivSize, plaintext, 0, iv, false);
        return plaintext;
    }

    private void doCtr(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset, byte[] iv, boolean encrypt) throws GeneralSecurityException {
        Cipher cipher = localCipher.get();
        byte[] counter = new byte[this.blockSize];
        System.arraycopy(iv, 0, counter, 0, this.ivSize);
        IvParameterSpec paramSpec = new IvParameterSpec(counter);
        if (encrypt) {
            cipher.init(1, (Key)this.keySpec, paramSpec);
        } else {
            cipher.init(2, (Key)this.keySpec, paramSpec);
        }
        int numBytes = cipher.doFinal(input, inputOffset, inputLen, output, outputOffset);
        if (numBytes != inputLen) {
            throw new GeneralSecurityException("stored output's length does not match input's length");
        }
    }
}

