/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.http;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.james.jmap.Endpoint;
import org.apache.james.jmap.JMAPRoute;
import org.apache.james.jmap.JMAPRoutes;
import org.apache.james.jmap.draft.exceptions.BadRequestException;
import org.apache.james.jmap.draft.exceptions.InternalErrorException;
import org.apache.james.jmap.draft.methods.RequestHandler;
import org.apache.james.jmap.draft.model.AuthenticatedRequest;
import org.apache.james.jmap.draft.model.InvocationRequest;
import org.apache.james.jmap.draft.model.InvocationResponse;
import org.apache.james.jmap.exceptions.UnauthorizedException;
import org.apache.james.jmap.http.Authenticator;
import org.apache.james.jmap.http.LoggingHelper;
import org.apache.james.jmap.http.UserProvisioner;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.HttpServerResponse;

public class JMAPApiRoutes
implements JMAPRoutes {
    public static final Logger LOGGER = LoggerFactory.getLogger(JMAPApiRoutes.class);
    private final ObjectMapper objectMapper;
    private final RequestHandler requestHandler;
    private final MetricFactory metricFactory;
    private final Authenticator authenticator;
    private final UserProvisioner userProvisioner;

    @Inject
    public JMAPApiRoutes(RequestHandler requestHandler, MetricFactory metricFactory, @Named(value="DRAFT") Authenticator authenticator, UserProvisioner userProvisioner) {
        this.requestHandler = requestHandler;
        this.metricFactory = metricFactory;
        this.authenticator = authenticator;
        this.userProvisioner = userProvisioner;
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
    }

    public Stream<JMAPRoute> routes() {
        return Stream.of(JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.POST, "/jmap")).action(this::post).corsHeaders(), JMAPRoute.builder().endpoint(new Endpoint(HttpMethod.OPTIONS, "/jmap")).action(CORS_CONTROL).noCorsHeaders());
    }

    private Mono<Void> post(HttpServerRequest request, HttpServerResponse response) {
        return this.authenticator.authenticate(request).flatMap(session -> this.userProvisioner.provisionUser((MailboxSession)session).then(Mono.from((Publisher)this.metricFactory.decoratePublisherWithTimerMetric("JMAP-request", this.post(request, response, (MailboxSession)session)))).subscriberContext(LoggingHelper.jmapAuthContext(session))).onErrorResume(BadRequestException.class, e -> this.handleBadRequest(response, LOGGER, (Throwable)e)).onErrorResume(UnauthorizedException.class, e -> this.handleAuthenticationFailure(response, LOGGER, (Throwable)e)).doOnEach(ReactorUtils.logOnError(e -> LOGGER.error("Unexpected error", e))).onErrorResume(e -> response.status(HttpResponseStatus.INTERNAL_SERVER_ERROR).send()).subscriberContext(LoggingHelper.jmapContext(request));
    }

    private Mono<Void> post(HttpServerRequest request, HttpServerResponse response, MailboxSession session) {
        Flux responses = this.requestAsJsonStream(request).map(InvocationRequest::deserialize).map(invocationRequest -> AuthenticatedRequest.decorate(invocationRequest, session)).concatMap(this.requestHandler::handle).map(InvocationResponse::asProtocolSpecification);
        return this.sendResponses(response, (Flux<Object[]>)responses);
    }

    private Mono<Void> sendResponses(HttpServerResponse response, Flux<Object[]> responses) {
        return responses.collectList().map(objects -> {
            try {
                return this.objectMapper.writeValueAsBytes(objects);
            }
            catch (JsonProcessingException e) {
                throw new InternalErrorException("error serialising JMAP API response json");
            }
        }).flatMap(json -> response.status(HttpResponseStatus.OK).header((CharSequence)HttpHeaderNames.CONTENT_TYPE, (CharSequence)"application/json").header((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (CharSequence)Integer.toString(((byte[])json).length)).sendByteArray((Publisher)Mono.just((Object)json)).then());
    }

    private Flux<JsonNode[]> requestAsJsonStream(HttpServerRequest req) {
        return req.receive().aggregate().asInputStream().map(inputStream -> {
            try {
                return (JsonNode[][])this.objectMapper.readValue(inputStream, JsonNode[][].class);
            }
            catch (IOException e) {
                throw new BadRequestException("Error deserializing JSON", e);
            }
        }).flatMapIterable(ImmutableList::copyOf);
    }
}

