/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.event;

import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.james.events.Event;
import org.apache.james.events.EventListener;
import org.apache.james.events.Group;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.RightManager;
import org.apache.james.mailbox.acl.ACLDiff;
import org.apache.james.mailbox.events.MailboxEvents;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.model.MailboxACL;
import org.apache.james.mailbox.model.MailboxPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropagateLookupRightListener
implements EventListener.GroupEventListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropagateLookupRightListener.class);
    private static final Group GROUP = new PropagateLookupRightListenerGroup();
    private final RightManager rightManager;
    private final MailboxManager mailboxManager;

    @Inject
    public PropagateLookupRightListener(RightManager rightManager, MailboxManager mailboxManager) {
        this.rightManager = rightManager;
        this.mailboxManager = mailboxManager;
    }

    public Group getDefaultGroup() {
        return GROUP;
    }

    public void event(Event event) throws MailboxException {
        MailboxSession mailboxSession = this.createMailboxSession(event);
        if (event instanceof MailboxEvents.MailboxACLUpdated) {
            MailboxEvents.MailboxACLUpdated aclUpdateEvent = (MailboxEvents.MailboxACLUpdated)event;
            MailboxPath mailboxPath = this.mailboxManager.getMailbox(aclUpdateEvent.getMailboxId(), mailboxSession).getMailboxPath();
            this.updateLookupRightOnParent(mailboxSession, mailboxPath, aclUpdateEvent.getAclDiff());
        } else if (event instanceof MailboxEvents.MailboxRenamed) {
            MailboxEvents.MailboxRenamed renamedEvent = (MailboxEvents.MailboxRenamed)event;
            this.updateLookupRightOnParent(mailboxSession, renamedEvent.getNewPath());
        }
    }

    public boolean isHandling(Event event) {
        return event instanceof MailboxEvents.MailboxACLUpdated || event instanceof MailboxEvents.MailboxRenamed;
    }

    private MailboxSession createMailboxSession(Event event) throws MailboxException {
        return this.mailboxManager.createSystemSession(event.getUsername());
    }

    private void updateLookupRightOnParent(MailboxSession session, MailboxPath path) throws MailboxException {
        MailboxACL acl = this.rightManager.listRights(path, session);
        this.listAncestors(session, path).forEach(parentMailboxPath -> this.updateLookupRight(session, (MailboxPath)parentMailboxPath, acl.getEntries().entrySet().stream().map(entry -> new MailboxACL.Entry((MailboxACL.EntryKey)entry.getKey(), (MailboxACL.Rfc4314Rights)entry.getValue()))));
    }

    private void updateLookupRightOnParent(MailboxSession mailboxSession, MailboxPath mailboxPath, ACLDiff aclDiff) {
        this.listAncestors(mailboxSession, mailboxPath).forEach(path -> this.updateLookupRight(mailboxSession, (MailboxPath)path, Stream.concat(aclDiff.addedEntries(), aclDiff.changedEntries())));
    }

    private void updateLookupRight(MailboxSession session, MailboxPath mailboxPath, Stream<MailboxACL.Entry> entries) {
        entries.filter(entry -> !((MailboxACL.EntryKey)entry.getKey()).isNegative()).filter(entry -> ((MailboxACL.Rfc4314Rights)entry.getValue()).contains(MailboxACL.Right.Lookup)).forEach(entry -> this.applyLookupRight(session, mailboxPath, (MailboxACL.Entry)entry));
    }

    private Stream<MailboxPath> listAncestors(MailboxSession mailboxSession, MailboxPath mailboxPath) {
        return mailboxPath.getHierarchyLevels(mailboxSession.getPathDelimiter()).stream().filter(Predicate.not(Predicate.isEqual(mailboxPath)));
    }

    private void applyLookupRight(MailboxSession session, MailboxPath mailboxPath, MailboxACL.Entry entry) {
        try {
            this.rightManager.applyRightsCommand(mailboxPath, MailboxACL.command().rights(new MailboxACL.Right[]{MailboxACL.Right.Lookup}).key((MailboxACL.EntryKey)entry.getKey()).asAddition(), session);
        }
        catch (MailboxException e) {
            LOGGER.error(String.format("Mailbox '%s' does not exist, user '%s' cannot share mailbox", mailboxPath, session.getUser().asString()), (Throwable)e);
        }
    }

    public static class PropagateLookupRightListenerGroup
    extends Group {
    }
}

