/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.utils;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import org.apache.james.backends.cassandra.init.configuration.CassandraConfiguration;

public class CassandraUtils {
    public static final CassandraUtils WITH_DEFAULT_CONFIGURATION = new CassandraUtils(CassandraConfiguration.DEFAULT_CONFIGURATION);
    private final CassandraConfiguration cassandraConfiguration;

    @Inject
    public CassandraUtils(CassandraConfiguration cassandraConfiguration) {
        this.cassandraConfiguration = cassandraConfiguration;
    }

    public Stream<Row> convertToStream(ResultSet resultSet) {
        return StreamSupport.stream(resultSet.spliterator(), true).peek(row -> this.ensureFetchedNextPage(resultSet));
    }

    private void ensureFetchedNextPage(ResultSet resultSet) {
        if (this.fetchNeeded(resultSet)) {
            resultSet.fetchMoreResults();
        }
    }

    private boolean fetchNeeded(ResultSet resultSet) {
        return resultSet.getAvailableWithoutFetching() == this.cassandraConfiguration.getFetchNextPageInAdvanceRow() && !resultSet.isFullyFetched();
    }
}

