/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.utils;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Optional;
import java.util.function.Function;
import javax.inject.Inject;
import net.javacrumbs.futureconverter.java8guava.FutureConverter;
import org.apache.james.util.ReactorUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class CassandraAsyncExecutor {
    private final Session session;

    @Inject
    public CassandraAsyncExecutor(Session session) {
        this.session = session;
    }

    public Mono<ResultSet> execute(Statement statement) {
        return Mono.fromFuture(() -> FutureConverter.toCompletableFuture((ListenableFuture)this.session.executeAsync(statement))).publishOn(Schedulers.elastic());
    }

    public Mono<Boolean> executeReturnApplied(Statement statement) {
        return this.execute(statement).map(ResultSet::wasApplied);
    }

    public Mono<Void> executeVoid(Statement statement) {
        return this.execute(statement).then();
    }

    public Mono<Row> executeSingleRow(Statement statement) {
        return this.executeSingleRowOptional(statement).handle(ReactorUtils.publishIfPresent());
    }

    public Flux<Row> executeRows(Statement statement) {
        return this.execute(statement).flatMapIterable(Function.identity());
    }

    public Mono<Optional<Row>> executeSingleRowOptional(Statement statement) {
        return this.execute(statement).map(resultSet -> Optional.ofNullable(resultSet.one()));
    }

    public Mono<Boolean> executeReturnExists(Statement statement) {
        return this.executeSingleRow(statement).hasElement();
    }
}

