/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.task;

import java.io.IOException;
import org.apache.james.task.TaskId;
import org.apache.james.task.TaskManagerWorker;
import org.apache.james.task.TaskWithId;
import org.apache.james.task.WorkQueue;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.UnicastProcessor;
import reactor.core.scheduler.Schedulers;

public class MemoryWorkQueue
implements WorkQueue {
    private final TaskManagerWorker worker;
    private final Disposable subscription;
    private final UnicastProcessor<TaskWithId> tasks;

    public MemoryWorkQueue(TaskManagerWorker worker) {
        this.worker = worker;
        this.tasks = UnicastProcessor.create();
        this.subscription = this.tasks.subscribeOn(Schedulers.elastic()).limitRate(1).concatMap(this::dispatchTaskToWorker).subscribe();
    }

    private Mono<?> dispatchTaskToWorker(TaskWithId taskWithId) {
        return this.worker.executeTask(taskWithId);
    }

    @Override
    public void submit(TaskWithId taskWithId) {
        this.tasks.onNext((Object)taskWithId);
    }

    @Override
    public void cancel(TaskId taskId) {
        this.worker.cancelTask(taskId);
    }

    @Override
    public void close() throws IOException {
        try {
            this.subscription.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.worker.close();
    }
}

