/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver.netty;

import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.protocols.api.Encryption;
import org.apache.james.protocols.api.Protocol;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.netty.BasicChannelUpstreamHandler;
import org.apache.james.protocols.netty.ProtocolMDCContextFactory;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.SMTPMDCContextFactory;
import org.apache.james.smtpserver.SMTPConstants;
import org.apache.james.smtpserver.netty.SmtpMetrics;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.MessageEvent;

@ChannelHandler.Sharable
public class SMTPChannelUpstreamHandler
extends BasicChannelUpstreamHandler {
    private final SmtpMetrics smtpMetrics;

    public SMTPChannelUpstreamHandler(Protocol protocol, Encryption encryption, SmtpMetrics smtpMetrics) {
        super((ProtocolMDCContextFactory)new SMTPMDCContextFactory(), protocol, encryption);
        this.smtpMetrics = smtpMetrics;
    }

    public SMTPChannelUpstreamHandler(Protocol protocol, SmtpMetrics smtpMetrics) {
        super((ProtocolMDCContextFactory)new SMTPMDCContextFactory(), protocol);
        this.smtpMetrics = smtpMetrics;
    }

    public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        super.channelConnected(ctx, e);
        this.smtpMetrics.getConnectionMetric().increment();
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        super.messageReceived(ctx, e);
        this.smtpMetrics.getCommandsMetric().increment();
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        super.channelDisconnected(ctx, e);
        this.smtpMetrics.getConnectionMetric().decrement();
    }

    protected void cleanup(ChannelHandlerContext ctx) {
        SMTPSession smtpSession = (SMTPSession)ctx.getAttachment();
        if (smtpSession != null) {
            smtpSession.getAttachment(SMTPConstants.MAIL, ProtocolSession.State.Transaction).ifPresent(LifecycleUtil::dispose);
            smtpSession.getAttachment(SMTPConstants.DATA_MIMEMESSAGE_STREAMSOURCE, ProtocolSession.State.Transaction).ifPresent(LifecycleUtil::dispose);
        }
        super.cleanup(ctx);
    }
}

