/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.parser;

import java.io.IOException;
import java.io.InputStream;
import org.apache.james.mime4j.parser.ContentHandler;
import org.apache.james.mime4j.stream.BodyDescriptor;
import org.apache.james.mime4j.stream.Field;
import org.apache.james.mime4j.util.ByteSequence;
import org.apache.james.mime4j.util.ContentUtil;
import org.junit.Assert;

class TestHandler
implements ContentHandler {
    final StringBuilder sb = new StringBuilder();

    TestHandler() {
    }

    private String escape(char c) {
        if (c == '&') {
            return "&amp;";
        }
        if (c == '>') {
            return "&gt;";
        }
        if (c == '<') {
            return "&lt;";
        }
        return "" + c;
    }

    private String escape(String s) {
        s = s.replaceAll("&", "&amp;");
        s = s.replaceAll(">", "&gt;");
        s = s.replaceAll("<", "&lt;");
        return s;
    }

    public void epilogue(InputStream is) throws IOException {
        int b;
        this.sb.append("<epilogue>\r\n");
        while ((b = is.read()) != -1) {
            this.sb.append(this.escape((char)b));
        }
        this.sb.append("</epilogue>\r\n");
    }

    public void preamble(InputStream is) throws IOException {
        int b;
        this.sb.append("<preamble>\r\n");
        while ((b = is.read()) != -1) {
            this.sb.append(this.escape((char)b));
        }
        this.sb.append("</preamble>\r\n");
    }

    public void startMultipart(BodyDescriptor bd) {
        this.sb.append("<multipart>\r\n");
    }

    public void body(BodyDescriptor bd, InputStream is) throws IOException {
        int b;
        this.sb.append("<body>\r\n");
        while ((b = is.read()) != -1) {
            this.sb.append(this.escape((char)b));
        }
        this.sb.append("</body>\r\n");
    }

    public void endMultipart() {
        this.sb.append("</multipart>\r\n");
    }

    public void startBodyPart() {
        this.sb.append("<body-part>\r\n");
    }

    public void endBodyPart() {
        this.sb.append("</body-part>\r\n");
    }

    public void startHeader() {
        this.sb.append("<header>\r\n");
    }

    public void field(Field field) {
        this.sb.append("<field>\r\n").append(this.escape(ContentUtil.decode((ByteSequence)field.getRaw()))).append("</field>\r\n");
    }

    public void endHeader() {
        this.sb.append("</header>\r\n");
    }

    public void startMessage() {
        this.sb.append("<message>\r\n");
    }

    public void endMessage() {
        this.sb.append("</message>\r\n");
    }

    public void raw(InputStream is) throws IOException {
        Assert.fail((String)"raw should never be called");
    }
}

