/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.snapshot;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;

public class SnapshotLogger
implements AutoCloseable {
    public static final String SNAPSHOT_LOG_NAME = "snapshot.log";
    public static final String SPLIT_CHAR = " ";
    public static final String END_FLAG = "END";
    public static final int FILE_NAME_OFFSET = 1;
    public static final int TIME_PARTITION_OFFSET = 2;
    public static final int SEQUENCE_OFFSET = 5;
    private File logFile;
    private BufferedOutputStream os;
    private FileOutputStream fos;

    public SnapshotLogger(File logFile) throws IOException {
        this.logFile = logFile;
        if (!logFile.getParentFile().exists() && !logFile.getParentFile().mkdirs()) {
            throw new IOException("Cannot create parent folder for " + logFile.getAbsolutePath());
        }
        if (!this.logFile.createNewFile()) {
            throw new IOException("Cannot create file " + logFile.getAbsolutePath());
        }
        this.fos = new FileOutputStream(logFile);
        this.os = new BufferedOutputStream(this.fos);
    }

    @Override
    public void close() throws Exception {
        this.fos.flush();
        this.fos.getFD().sync();
        this.os.close();
    }

    public void logFile(File sourceFile) throws IOException {
        String[] splitInfo = sourceFile.getAbsolutePath().split(File.separator.equals("\\") ? "\\\\" : "/");
        int length = splitInfo.length;
        String fileName = splitInfo[length - 1];
        String timePartition = splitInfo[length - 2];
        String sequence = splitInfo[length - 5];
        this.os.write(fileName.getBytes(StandardCharsets.UTF_8));
        this.os.write(SPLIT_CHAR.getBytes(StandardCharsets.UTF_8));
        this.os.write(timePartition.getBytes(StandardCharsets.UTF_8));
        this.os.write(SPLIT_CHAR.getBytes(StandardCharsets.UTF_8));
        this.os.write(sequence.getBytes(StandardCharsets.UTF_8));
        this.os.write("\n".getBytes(StandardCharsets.UTF_8));
        this.os.flush();
    }

    public void logSnapshotId(String id) throws IOException {
        this.os.write(id.getBytes(StandardCharsets.UTF_8));
        this.os.write("\n".getBytes(StandardCharsets.UTF_8));
    }

    public void logEnd() throws IOException {
        this.os.write(END_FLAG.getBytes(StandardCharsets.UTF_8));
    }

    public void cleanUpWhenFailed() throws IOException {
        this.os.close();
        Files.delete(this.logFile.toPath());
    }
}

